/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.view;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.DefaultAuthenticationAttributeReleasePolicy;
import org.apereo.cas.authentication.DefaultAuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.support.DefaultCasProtocolAttributeEncoder;
import org.apereo.cas.authentication.support.NoOpProtocolAttributeEncoder;
import org.apereo.cas.services.AbstractRegisteredService;
import org.apereo.cas.services.DefaultServicesManager;
import org.apereo.cas.services.DefaultServicesManagerRegisteredServiceLocator;
import org.apereo.cas.services.InMemoryServiceRegistry;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.ServicesManagerConfigurationContext;
import org.apereo.cas.support.saml.AbstractOpenSamlTests;
import org.apereo.cas.support.saml.authentication.SamlResponseBuilder;
import org.apereo.cas.support.saml.authentication.principal.SamlServiceFactory;
import org.apereo.cas.support.saml.util.Saml10ObjectBuilder;
import org.apereo.cas.support.saml.web.view.Saml10SuccessResponseView;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.validation.Assertion;
import org.apereo.cas.validation.AuthenticationAttributeReleasePolicy;
import org.apereo.cas.validation.DefaultAssertionBuilder;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.DefaultArgumentExtractor;
import org.apereo.cas.web.view.attributes.NoOpProtocolAttributesRenderer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Tag(value="SAML")
public class Saml10SuccessResponseViewTests
extends AbstractOpenSamlTests {
    private static final String TEST_VALUE = "testValue";
    private static final String TEST_ATTRIBUTE = "testAttribute";
    private static final String PRINCIPAL_ID = "testPrincipal";
    private Saml10SuccessResponseView response;

    @BeforeEach
    public void initialize() {
        StaticApplicationContext appCtx = new StaticApplicationContext();
        appCtx.refresh();
        ArrayList<AbstractRegisteredService> list = new ArrayList<AbstractRegisteredService>();
        list.add(RegisteredServiceTestUtils.getRegisteredService((String)"https://.+"));
        InMemoryServiceRegistry dao = new InMemoryServiceRegistry((ConfigurableApplicationContext)appCtx, list, new ArrayList());
        ServicesManagerConfigurationContext context = ServicesManagerConfigurationContext.builder().serviceRegistry((ServiceRegistry)dao).applicationContext((ConfigurableApplicationContext)appCtx).environments(new HashSet(0)).servicesCache(Caffeine.newBuilder().build()).registeredServiceLocators(List.of(new DefaultServicesManagerRegisteredServiceLocator())).build();
        DefaultServicesManager mgmr = new DefaultServicesManager(context);
        mgmr.load();
        DefaultCasProtocolAttributeEncoder protocolAttributeEncoder = new DefaultCasProtocolAttributeEncoder((ServicesManager)mgmr, CipherExecutor.noOpOfStringToString());
        Saml10ObjectBuilder builder = new Saml10ObjectBuilder(this.configBean);
        SamlResponseBuilder samlResponseBuilder = new SamlResponseBuilder(builder, "testIssuer", "whatever", 1000, "PT30S", (ProtocolAttributeEncoder)new NoOpProtocolAttributeEncoder(), (ServicesManager)mgmr);
        this.response = new Saml10SuccessResponseView((ProtocolAttributeEncoder)protocolAttributeEncoder, (ServicesManager)mgmr, (ArgumentExtractor)new DefaultArgumentExtractor((ServiceFactory)new SamlServiceFactory()), StandardCharsets.UTF_8.name(), (AuthenticationAttributeReleasePolicy)new DefaultAuthenticationAttributeReleasePolicy("attribute"), (AuthenticationServiceSelectionPlan)new DefaultAuthenticationServiceSelectionPlan(new AuthenticationServiceSelectionStrategy[0]), NoOpProtocolAttributesRenderer.INSTANCE, samlResponseBuilder);
    }

    @Test
    public void verifyResponse() throws Exception {
        HashMap<String, Assertion> model = new HashMap<String, Assertion>();
        HashMap<String, List<Object>> attributes = new HashMap<String, List<Object>>();
        attributes.put(TEST_ATTRIBUTE, List.of(TEST_VALUE));
        attributes.put("testEmptyCollection", new ArrayList(0));
        attributes.put("testAttributeCollection", Arrays.asList("tac1", "tac2"));
        Principal principal = PrincipalFactoryUtils.newPrincipalFactory().createPrincipal(PRINCIPAL_ID, attributes);
        HashMap<String, List<String>> authAttributes = new HashMap<String, List<String>>();
        authAttributes.put("samlAuthenticationStatementAuthMethod", List.of("urn:ietf:rfc:2246"));
        authAttributes.put("testSamlAttribute", List.of("value"));
        Authentication primary = CoreAuthenticationTestUtils.getAuthentication((Principal)principal, authAttributes);
        Assertion assertion = new DefaultAssertionBuilder(primary).with(List.of(primary)).with(CoreAuthenticationTestUtils.getWebApplicationService()).with(true).build();
        model.put("assertion", assertion);
        MockHttpServletResponse servletResponse = new MockHttpServletResponse();
        this.response.renderMergedOutputModel(model, (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)servletResponse);
        String written = servletResponse.getContentAsString();
        Assertions.assertTrue((boolean)written.contains(PRINCIPAL_ID));
        Assertions.assertTrue((boolean)written.contains(TEST_ATTRIBUTE));
        Assertions.assertTrue((boolean)written.contains(TEST_VALUE));
        Assertions.assertFalse((boolean)written.contains("testEmptyCollection"));
        Assertions.assertTrue((boolean)written.contains("testAttributeCollection"));
        Assertions.assertTrue((boolean)written.contains("tac1"));
        Assertions.assertTrue((boolean)written.contains("tac2"));
        Assertions.assertTrue((boolean)written.contains("urn:ietf:rfc:2246"));
        Assertions.assertTrue((boolean)written.contains("AuthenticationMethod"));
        Assertions.assertTrue((boolean)written.contains("AssertionID"));
        Assertions.assertTrue((boolean)written.contains("saml1:Attribute"));
        Assertions.assertTrue((boolean)written.contains("saml1p:Response"));
        Assertions.assertTrue((boolean)written.contains("saml1:Assertion"));
    }

    @Test
    public void verifyResponseWithNoAttributes() throws Exception {
        HashMap<String, Assertion> model = new HashMap<String, Assertion>();
        Principal principal = PrincipalFactoryUtils.newPrincipalFactory().createPrincipal(PRINCIPAL_ID);
        HashMap<String, List<String>> authAttributes = new HashMap<String, List<String>>();
        authAttributes.put("samlAuthenticationStatementAuthMethod", List.of("urn:ietf:rfc:2246"));
        authAttributes.put("testSamlAttribute", List.of("value"));
        Authentication primary = CoreAuthenticationTestUtils.getAuthentication((Principal)principal, authAttributes);
        Assertion assertion = new DefaultAssertionBuilder(primary).with(List.of(primary)).with(CoreAuthenticationTestUtils.getWebApplicationService()).with(true).build();
        model.put("assertion", assertion);
        MockHttpServletResponse servletResponse = new MockHttpServletResponse();
        this.response.renderMergedOutputModel(model, (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)servletResponse);
        String written = servletResponse.getContentAsString();
        Assertions.assertTrue((boolean)written.contains(PRINCIPAL_ID));
        Assertions.assertTrue((boolean)written.contains("urn:ietf:rfc:2246"));
        Assertions.assertTrue((boolean)written.contains("AuthenticationMethod="));
    }

    @Test
    public void verifyResponseWithoutAuthMethod() throws Exception {
        HashMap<String, Assertion> model = new HashMap<String, Assertion>();
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        attributes.put(TEST_ATTRIBUTE, List.of(TEST_VALUE));
        Principal principal = PrincipalFactoryUtils.newPrincipalFactory().createPrincipal(PRINCIPAL_ID, attributes);
        HashMap<String, List<Object>> authnAttributes = new HashMap<String, List<Object>>();
        authnAttributes.put("authnAttribute1", List.of("authnAttrbuteV1"));
        authnAttributes.put("authnAttribute2", List.of("authnAttrbuteV2"));
        authnAttributes.put("org.apereo.cas.authentication.principal.REMEMBER_ME", List.of(Boolean.TRUE));
        Authentication primary = CoreAuthenticationTestUtils.getAuthentication((Principal)principal, authnAttributes);
        Assertion assertion = new DefaultAssertionBuilder(primary).with(List.of(primary)).with(CoreAuthenticationTestUtils.getWebApplicationService()).with(true).build();
        model.put("assertion", assertion);
        MockHttpServletResponse servletResponse = new MockHttpServletResponse();
        this.response.renderMergedOutputModel(model, (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)servletResponse);
        String written = servletResponse.getContentAsString();
        Assertions.assertTrue((boolean)written.contains(PRINCIPAL_ID));
        Assertions.assertTrue((boolean)written.contains(TEST_ATTRIBUTE));
        Assertions.assertTrue((boolean)written.contains(TEST_VALUE));
        Assertions.assertTrue((boolean)written.contains("authnAttribute1"));
        Assertions.assertTrue((boolean)written.contains("authnAttribute2"));
        Assertions.assertTrue((boolean)written.contains("longTermAuthenticationRequestTokenUsed"));
        Assertions.assertTrue((boolean)written.contains("urn:oasis:names:tc:SAML:1.0:am:unspecified"));
    }
}

