/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.api.PrincipalProvisioner;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.scim.ScimProperties;
import org.apereo.cas.scim.v1.ScimV1PrincipalAttributeMapper;
import org.apereo.cas.scim.v1.ScimV1PrincipalProvisioner;
import org.apereo.cas.scim.v2.ScimV2PrincipalAttributeMapper;
import org.apereo.cas.scim.v2.ScimV2PrincipalProvisioner;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlan;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.PrincipalScimProvisionerAction;
import org.apereo.cas.web.flow.ScimWebflowConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@Configuration(value="casScimConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableScheduling
public class CasScimConfiguration
implements CasWebflowExecutionPlanConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasScimConfiguration.class);
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private FlowDefinitionRegistry loginFlowDefinitionRegistry;
    @Autowired
    private FlowBuilderServices flowBuilderServices;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ApplicationContext applicationContext;

    @ConditionalOnMissingBean(name={"scimWebflowConfigurer"})
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    public CasWebflowConfigurer scimWebflowConfigurer() {
        return new ScimWebflowConfigurer(this.flowBuilderServices, this.loginFlowDefinitionRegistry, this.applicationContext, this.casProperties);
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"scim2PrincipalAttributeMapper"})
    public ScimV2PrincipalAttributeMapper scim2PrincipalAttributeMapper() {
        return new ScimV2PrincipalAttributeMapper();
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"scim1PrincipalAttributeMapper"})
    public ScimV1PrincipalAttributeMapper scim1PrincipalAttributeMapper() {
        return new ScimV1PrincipalAttributeMapper();
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"scimProvisioner"})
    public PrincipalProvisioner scimProvisioner() {
        ScimProperties scim = this.casProperties.getScim();
        if (StringUtils.isBlank((CharSequence)scim.getTarget())) {
            throw new BeanCreationException("Scim target cannot be blank");
        }
        if (this.casProperties.getScim().getVersion() == 1L) {
            return new ScimV1PrincipalProvisioner(scim.getTarget(), scim.getOauthToken(), scim.getUsername(), scim.getPassword(), this.scim1PrincipalAttributeMapper());
        }
        return new ScimV2PrincipalProvisioner(scim.getTarget(), scim.getOauthToken(), scim.getUsername(), scim.getPassword(), this.scim2PrincipalAttributeMapper());
    }

    @ConditionalOnMissingBean(name={"principalScimProvisionerAction"})
    @Bean
    @RefreshScope
    public Action principalScimProvisionerAction() {
        return new PrincipalScimProvisionerAction(this.scimProvisioner());
    }

    public void configureWebflowExecutionPlan(CasWebflowExecutionPlan plan) {
        plan.registerWebflowConfigurer(this.scimWebflowConfigurer());
    }
}

