/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.scim.v1;

import com.unboundid.scim.data.Entry;
import com.unboundid.scim.data.Name;
import com.unboundid.scim.data.UserResource;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScimV1PrincipalAttributeMapper {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ScimV1PrincipalAttributeMapper.class);

    public String getPrincipalAttributeValue(Principal p, String attributeName) {
        Map attributes = p.getAttributes();
        if (attributes.containsKey(attributeName)) {
            return CollectionUtils.toCollection(attributes.get(attributeName)).iterator().next().toString();
        }
        return null;
    }

    public void map(UserResource user, Principal p, Credential credential) {
        user.setUserName(p.getId());
        if (credential instanceof UsernamePasswordCredential) {
            user.setPassword(((UsernamePasswordCredential)UsernamePasswordCredential.class.cast(credential)).getPassword());
        }
        user.setActive(Boolean.TRUE);
        user.setNickName(this.getPrincipalAttributeValue(p, "nickName"));
        user.setDisplayName(this.getPrincipalAttributeValue(p, "displayName"));
        Name name = new Name(this.getPrincipalAttributeValue(p, "formattedName"), this.getPrincipalAttributeValue(p, "familyName"), this.getPrincipalAttributeValue(p, "middleName"), this.getPrincipalAttributeValue(p, "givenName"), this.getPrincipalAttributeValue(p, "honorificPrefix"), this.getPrincipalAttributeValue(p, "honorificSuffix"));
        user.setName(name);
        Entry entry = new Entry((Object)this.getPrincipalAttributeValue(p, "mail"), "primary");
        user.setEmails((Collection)CollectionUtils.wrap((Object)entry));
        entry = new Entry((Object)this.getPrincipalAttributeValue(p, "phoneNumber"), "primary");
        user.setPhoneNumbers((Collection)CollectionUtils.wrap((Object)entry));
    }
}

