/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.scim.v1;

import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.data.UserResource;
import com.unboundid.scim.schema.CoreSchema;
import com.unboundid.scim.sdk.OAuthToken;
import com.unboundid.scim.sdk.Resources;
import com.unboundid.scim.sdk.SCIMEndpoint;
import com.unboundid.scim.sdk.SCIMService;
import java.net.URI;
import javax.ws.rs.core.MediaType;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.api.PrincipalProvisioner;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.scim.v1.ScimV1PrincipalAttributeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScimV1PrincipalProvisioner
implements PrincipalProvisioner {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ScimV1PrincipalProvisioner.class);
    private final SCIMEndpoint<UserResource> endpoint;
    private final ScimV1PrincipalAttributeMapper mapper;

    public ScimV1PrincipalProvisioner(String target, String oauthToken, String username, String password, ScimV1PrincipalAttributeMapper mapper) {
        this.mapper = mapper;
        URI uri = URI.create(target);
        SCIMService scimService = StringUtils.isNotBlank((CharSequence)oauthToken) ? new SCIMService(uri, new OAuthToken(oauthToken)) : new SCIMService(uri, username, password);
        scimService.setAcceptType(MediaType.APPLICATION_JSON_TYPE);
        this.endpoint = scimService.getUserEndpoint();
    }

    @Override
    public boolean create(Authentication auth, Principal p, Credential credential) {
        try {
            Resources resources = this.endpoint.query("userName eq \"" + p.getId() + "\"");
            if (resources.getTotalResults() <= 0L) {
                LOGGER.debug("User [{}] not found", (Object)p.getId());
                return false;
            }
            UserResource user = (UserResource)resources.iterator().next();
            if (user != null) {
                return this.updateUserResource(user, p, credential);
            }
            return this.createUserResource(p, credential);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    protected boolean createUserResource(Principal p, Credential credential) {
        UserResource user = new UserResource(CoreSchema.USER_DESCRIPTOR);
        this.mapper.map(user, p, credential);
        return this.endpoint.create((BaseResource)user, new String[0]) != null;
    }

    protected boolean updateUserResource(UserResource user, Principal p, Credential credential) {
        this.mapper.map(user, p, credential);
        return this.endpoint.update((BaseResource)user) != null;
    }
}

