/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.scim.v2;

import com.unboundid.scim2.common.types.Email;
import com.unboundid.scim2.common.types.Name;
import com.unboundid.scim2.common.types.PhoneNumber;
import com.unboundid.scim2.common.types.UserResource;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScimV2PrincipalAttributeMapper {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ScimV2PrincipalAttributeMapper.class);

    public String getPrincipalAttributeValue(Principal p, String attributeName) {
        Map attributes = p.getAttributes();
        if (attributes.containsKey(attributeName)) {
            return CollectionUtils.toCollection(attributes.get(attributeName)).iterator().next().toString();
        }
        return null;
    }

    public void map(UserResource user, Principal p, Credential credential) {
        user.setUserName(p.getId());
        if (credential instanceof UsernamePasswordCredential) {
            user.setPassword(((UsernamePasswordCredential)UsernamePasswordCredential.class.cast(credential)).getPassword());
        }
        user.setActive(Boolean.TRUE);
        String attr = this.getPrincipalAttributeValue(p, "nickName");
        user.setNickName(attr);
        attr = this.getPrincipalAttributeValue(p, "displayName");
        user.setDisplayName(attr);
        Name name = new Name();
        attr = this.getPrincipalAttributeValue(p, "givenName");
        name.setGivenName(attr);
        attr = this.getPrincipalAttributeValue(p, "familyName");
        name.setFamilyName(attr);
        attr = this.getPrincipalAttributeValue(p, "middleName");
        name.setMiddleName(attr);
        user.setName(name);
        Email email = new Email();
        email.setPrimary(Boolean.TRUE);
        attr = this.getPrincipalAttributeValue(p, "mail");
        if (StringUtils.isBlank((CharSequence)attr)) {
            attr = this.getPrincipalAttributeValue(p, "email");
        }
        email.setValue(attr);
        user.setEmails(CollectionUtils.wrap((Object)email));
        PhoneNumber phone = new PhoneNumber();
        phone.setPrimary(Boolean.TRUE);
        attr = this.getPrincipalAttributeValue(p, "phone");
        if (StringUtils.isBlank((CharSequence)attr)) {
            attr = this.getPrincipalAttributeValue(p, "phoneNumber");
        }
        phone.setValue(attr);
        user.setPhoneNumbers(CollectionUtils.wrap((Object)phone));
    }
}

