/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.scim.v2;

import com.unboundid.scim2.client.ScimService;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.types.UserResource;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.api.PrincipalProvisioner;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.scim.v2.ScimV2PrincipalAttributeMapper;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.client.oauth2.OAuth2ClientSupport;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScimV2PrincipalProvisioner
implements PrincipalProvisioner {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ScimV2PrincipalProvisioner.class);
    private final ScimService scimService;
    private final ScimV2PrincipalAttributeMapper mapper;

    public ScimV2PrincipalProvisioner(String target, String oauthToken, String username, String password, ScimV2PrincipalAttributeMapper mapper) {
        ClientConfig config = new ClientConfig();
        ApacheConnectorProvider connectorProvider = new ApacheConnectorProvider();
        config.connectorProvider((ConnectorProvider)connectorProvider);
        Client client = ClientBuilder.newClient((Configuration)config);
        if (StringUtils.isNotBlank((CharSequence)oauthToken)) {
            client.register((Object)OAuth2ClientSupport.feature((String)oauthToken));
        }
        if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
            client.register((Object)HttpAuthenticationFeature.basic((String)username, (String)password));
        }
        WebTarget webTarget = client.target(target);
        this.scimService = new ScimService(webTarget);
        this.mapper = mapper;
    }

    @Override
    public boolean create(Authentication auth, Principal p, Credential credential) {
        try {
            UserResource currentUser = (UserResource)this.scimService.retrieve("Users", p.getId(), UserResource.class);
            if (currentUser != null) {
                return this.updateUserResource(currentUser, p, credential);
            }
            return this.createUserResource(p, credential);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    protected boolean updateUserResource(UserResource user, Principal p, Credential credential) {
        this.mapper.map(user, p, credential);
        return this.scimService.replace((ScimResource)user) != null;
    }

    protected boolean createUserResource(Principal p, Credential credential) {
        UserResource user = new UserResource();
        this.mapper.map(user, p, credential);
        return this.scimService.create("Users", (ScimResource)user) != null;
    }
}

