/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.scim.v2;

import com.unboundid.scim2.common.types.Email;
import com.unboundid.scim2.common.types.Name;
import com.unboundid.scim2.common.types.PhoneNumber;
import com.unboundid.scim2.common.types.UserResource;
import java.util.Map;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.util.CollectionUtils;

public class ScimV2PrincipalAttributeMapper {
    public String getPrincipalAttributeValue(Principal p, String attributeName) {
        Map attributes = p.getAttributes();
        if (attributes.containsKey(attributeName)) {
            return CollectionUtils.toCollection(attributes.get(attributeName)).iterator().next().toString();
        }
        return null;
    }

    public void map(UserResource user, Principal p, Credential credential) {
        user.setUserName(p.getId());
        if (credential instanceof UsernamePasswordCredential) {
            user.setPassword(((UsernamePasswordCredential)UsernamePasswordCredential.class.cast(credential)).getPassword());
        }
        user.setActive(Boolean.TRUE);
        user.setNickName(this.getPrincipalAttributeValue(p, "nickName"));
        user.setDisplayName(this.getPrincipalAttributeValue(p, "displayName"));
        Name name = new Name();
        name.setGivenName(this.getPrincipalAttributeValue(p, "givenName"));
        name.setFamilyName(this.getPrincipalAttributeValue(p, "familyName"));
        name.setMiddleName(this.getPrincipalAttributeValue(p, "middleName"));
        user.setName(name);
        Email email = new Email();
        email.setPrimary(Boolean.TRUE);
        email.setValue(this.getPrincipalAttributeValue(p, "email"));
        user.setEmails(CollectionUtils.wrap((Object)email));
        PhoneNumber phone = new PhoneNumber();
        phone.setPrimary(Boolean.TRUE);
        phone.setValue(this.getPrincipalAttributeValue(p, "phoneNumber"));
        user.setPhoneNumbers(CollectionUtils.wrap((Object)phone));
    }
}

