/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import lombok.Generated;
import org.apereo.cas.api.PrincipalProvisioner;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class PrincipalScimProvisionerAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PrincipalScimProvisionerAction.class);
    private final PrincipalProvisioner scimProvisioner;

    protected Event doExecute(RequestContext requestContext) {
        Credential c = WebUtils.getCredential((RequestContext)requestContext);
        if (c == null) {
            LOGGER.warn("No credential found in the request context to provision");
            return this.success();
        }
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        if (authentication == null) {
            LOGGER.warn("No authentication found in the request context to provision");
            return this.success();
        }
        Principal p = authentication.getPrincipal();
        LOGGER.debug("Starting to provision principal [{}]", (Object)p);
        boolean res = this.scimProvisioner.create(authentication, p, c);
        if (res) {
            LOGGER.debug("Provisioning of principal [{}] executed successfully", (Object)p);
        } else {
            LOGGER.warn("Provisioning of principal [{}] has failed", (Object)p);
        }
        return this.success();
    }

    @Generated
    public PrincipalScimProvisionerAction(PrincipalProvisioner scimProvisioner) {
        this.scimProvisioner = scimProvisioner;
    }
}

