/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.sentry;

import io.sentry.spring.boot.jakarta.SentryAutoConfiguration;
import org.apereo.cas.config.CasSentryAutoConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.monitor.Monitorable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.aop.AopAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.autoconfigure.actuate.observability.AutoConfigureObservability;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@SpringBootTest(classes={RefreshAutoConfiguration.class, WebMvcAutoConfiguration.class, AopAutoConfiguration.class, SentryAutoConfiguration.class, CasSentryAutoConfiguration.class, SentryMonitoringTestConfiguration.class})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableAspectJAutoProxy
@Tag(value="Simple")
@AutoConfigureObservability
class SentryMonitoringAspectTests {
    @Autowired
    @Qualifier(value="greeter")
    private Greeter greeter;

    SentryMonitoringAspectTests() {
    }

    @Test
    void verifyOperation() throws Throwable {
        Assertions.assertNotNull((Object)this.greeter.greet(false));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.greeter.greet(true));
    }

    @FunctionalInterface
    @Monitorable(type="Greeting")
    private static interface Greeter {
        public String greet(boolean var1);
    }

    @TestConfiguration(proxyBeanMethods=false)
    static class SentryMonitoringTestConfiguration {
        SentryMonitoringTestConfiguration() {
        }

        @Bean
        public Greeter greeter() {
            return fail -> {
                if (fail) {
                    throw new IllegalArgumentException("Failed");
                }
                return "Hello, World!";
            };
        }
    }
}

