/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategyConfigurer;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.ShibbolethIdPEntityIdAuthenticationServiceSelectionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="externalShibbolethIdPAuthenticationServiceSelectionStrategyConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class ExternalShibbolethIdPAuthenticationServiceSelectionStrategyConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalShibbolethIdPAuthenticationServiceSelectionStrategyConfiguration.class);
    @Autowired
    @Qualifier(value="registeredServiceAccessStrategyEnforcer")
    private ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ServiceFactory<WebApplicationService> webApplicationServiceFactory;

    @ConditionalOnMissingBean(name={"shibbolethIdPEntityIdAuthenticationServiceSelectionStrategy"})
    @Bean
    @RefreshScope
    public AuthenticationServiceSelectionStrategy shibbolethIdPEntityIdAuthenticationServiceSelectionStrategy() {
        return new ShibbolethIdPEntityIdAuthenticationServiceSelectionStrategy(this.webApplicationServiceFactory, this.casProperties.getAuthn().getShibIdp().getServerUrl(), (ServicesManager)this.servicesManager.getObject(), (AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject());
    }

    @Bean
    public AuthenticationServiceSelectionStrategyConfigurer shibbolethIdPAuthenticationServiceSelectionStrategyConfigurer() {
        return plan -> {
            if (StringUtils.isNotBlank((CharSequence)this.casProperties.getAuthn().getShibIdp().getServerUrl())) {
                plan.registerStrategy(this.shibbolethIdPEntityIdAuthenticationServiceSelectionStrategy());
            } else {
                LOGGER.warn("Shibboleth IdP url is not specified; External authentication requests by the IdP will not be recognized");
            }
        };
    }
}

