/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml;

import com.google.common.base.Splitter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShibbolethIdPEntityIdAuthenticationServiceSelectionStrategy
implements AuthenticationServiceSelectionStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ShibbolethIdPEntityIdAuthenticationServiceSelectionStrategy.class);
    private static final long serialVersionUID = -2059445756475980894L;
    private final int order = Integer.MIN_VALUE;
    private final transient ServiceFactory webApplicationServiceFactory;
    private final String idpServerPrefix;
    private final transient ServicesManager servicesManager;
    private final transient AuditableExecution registeredServiceAccessStrategyEnforcer;

    protected static Optional<String> getEntityIdAsParameter(Service service) {
        try {
            URIBuilder builder = new URIBuilder(service.getId());
            Optional<NameValuePair> param = builder.getQueryParams().stream().filter(p -> p.getName().equals("entityId")).findFirst();
            if (param.isPresent()) {
                LOGGER.debug("Found entity Id in service id [{}]", (Object)param.get().getValue());
                return Optional.of(param.get().getValue());
            }
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext();
            if (request != null && StringUtils.isNotBlank((CharSequence)request.getQueryString())) {
                String[] query = request.getQueryString().split("&");
                Optional<String> paramRequest = Arrays.stream(query).map(p -> {
                    List params = Splitter.on((String)"=").splitToList((CharSequence)p);
                    return Pair.of((Object)((String)params.get(0)), (Object)((String)params.get(1)));
                }).filter(p -> ((String)p.getKey()).equals("entityId")).map(Pair::getValue).map(EncodingUtils::urlDecode).findFirst();
                LOGGER.debug("Found entity id as part of request url [{}]", paramRequest);
                return paramRequest;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return Optional.empty();
    }

    public Service resolveServiceFrom(Service service) {
        Optional<String> result = ShibbolethIdPEntityIdAuthenticationServiceSelectionStrategy.getEntityIdAsParameter(service);
        if (result.isPresent()) {
            String entityId = result.get();
            LOGGER.debug("Located entity id [{}] from service authentication request at [{}]", (Object)entityId, (Object)service.getId());
            if (this.isEntityIdServiceRegistered(entityId)) {
                return this.webApplicationServiceFactory.createService(entityId);
            }
            LOGGER.debug("Entity id [{}] not registered as individual service", (Object)entityId);
        }
        LOGGER.debug("Could not located entity id from service authentication request at [{}]", (Object)service.getId());
        return service;
    }

    public boolean supports(Service service) {
        String casPattern = "^".concat(this.idpServerPrefix).concat(".*");
        return service != null && service.getId().matches(casPattern) && ShibbolethIdPEntityIdAuthenticationServiceSelectionStrategy.getEntityIdAsParameter(service).isPresent();
    }

    private boolean isEntityIdServiceRegistered(String entityId) {
        RegisteredService registeredService = this.servicesManager.findServiceBy(entityId);
        AuditableContext audit = AuditableContext.builder().registeredService(registeredService).build();
        return !this.registeredServiceAccessStrategyEnforcer.execute(audit).isExecutionFailure();
    }

    @Generated
    public ShibbolethIdPEntityIdAuthenticationServiceSelectionStrategy(ServiceFactory webApplicationServiceFactory, String idpServerPrefix, ServicesManager servicesManager, AuditableExecution registeredServiceAccessStrategyEnforcer) {
        this.webApplicationServiceFactory = webApplicationServiceFactory;
        this.idpServerPrefix = idpServerPrefix;
        this.servicesManager = servicesManager;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public ServiceFactory getWebApplicationServiceFactory() {
        return this.webApplicationServiceFactory;
    }

    @Generated
    public String getIdpServerPrefix() {
        return this.idpServerPrefix;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public AuditableExecution getRegisteredServiceAccessStrategyEnforcer() {
        return this.registeredServiceAccessStrategyEnforcer;
    }
}

