/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.sms;

import com.nexmo.client.NexmoClient;
import com.nexmo.client.sms.MessageStatus;
import com.nexmo.client.sms.SmsSubmissionResponse;
import com.nexmo.client.sms.SmsSubmissionResponseMessage;
import com.nexmo.client.sms.messages.Message;
import com.nexmo.client.sms.messages.TextMessage;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.configuration.model.support.sms.NexmoProperties;
import org.apereo.cas.util.io.SmsSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NexmoSmsSender
implements SmsSender {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(NexmoSmsSender.class);
    private final NexmoClient nexmoClient;

    public NexmoSmsSender(NexmoProperties nexmo) {
        NexmoClient.Builder builder = new NexmoClient.Builder();
        this.nexmoClient = builder.apiKey(nexmo.getApiToken()).apiSecret(nexmo.getApiSecret()).signatureSecret(nexmo.getSignatureSecret()).build();
    }

    public boolean send(String from, String to, String message) {
        try {
            TextMessage textMessage = new TextMessage(from, to, message);
            SmsSubmissionResponse response = this.nexmoClient.getSmsClient().submitMessage((Message)textMessage);
            if (response.getMessageCount() > 0) {
                List<SmsSubmissionResponseMessage> results = response.getMessages().stream().filter(res -> res.getStatus() != MessageStatus.OK).collect(Collectors.toList());
                if (results.isEmpty()) {
                    return true;
                }
                results.forEach(res -> LOGGER.error("Text message submission has failed: [{}]", res));
            } else {
                LOGGER.error("No text messages could be sent. Response [{}]", (Object)response);
            }
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            LOGGER.error(e.getMessage());
        }
        return false;
    }

    @Generated
    public NexmoClient getNexmoClient() {
        return this.nexmoClient;
    }
}

