/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionSet;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class SpengoWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    private static final String SPNEGO = "spnego";
    private static final String START_SPNEGO_AUTHENTICATE = "startSpnegoAuthenticate";
    private static final String SPNEGO_NEGOTIATE = "negociateSpnego";
    private static final String EVALUATE_SPNEGO_CLIENT = "evaluateClientRequest";

    public SpengoWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, ApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
    }

    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            this.createStartSpnegoAction(flow);
            this.createEvaluateSpnegoClientAction(flow);
            ActionState spnego = this.createSpnegoActionState(flow);
            this.registerMultifactorProvidersStateTransitionsIntoWebflow((TransitionableState)spnego);
            this.augmentWebflowToStartSpnego(flow);
        }
    }

    private void augmentWebflowToStartSpnego(Flow flow) {
        ActionState state = (ActionState)this.getState(flow, "initializeLoginForm", ActionState.class);
        this.createTransitionForState((TransitionableState)state, "success", START_SPNEGO_AUTHENTICATE, true);
    }

    private void createStartSpnegoAction(Flow flow) {
        ActionState actionState = this.createActionState(flow, START_SPNEGO_AUTHENTICATE, (Action)this.createEvaluateAction(SPNEGO_NEGOTIATE));
        actionState.getTransitionSet().add(this.createTransition("success", SPNEGO));
        actionState.getTransitionSet().add(this.createTransition("error", "viewLoginForm"));
    }

    private ActionState createSpnegoActionState(Flow flow) {
        ActionState spnego = this.createActionState(flow, SPNEGO, (Action)this.createEvaluateAction(SPNEGO));
        TransitionSet transitions = spnego.getTransitionSet();
        transitions.add(this.createTransition("success", "sendTicketGrantingTicket"));
        transitions.add(this.createTransition("error", "viewLoginForm"));
        transitions.add(this.createTransition("authenticationFailure", "viewLoginForm"));
        spnego.getExitActionList().add((Action)this.createEvaluateAction("clearWebflowCredentialsAction"));
        return spnego;
    }

    private void createEvaluateSpnegoClientAction(Flow flow) {
        ActionState evaluateClientRequest = this.createActionState(flow, EVALUATE_SPNEGO_CLIENT, (Action)this.createEvaluateAction(this.casProperties.getAuthn().getSpnego().getHostNameClientActionStrategy()));
        evaluateClientRequest.getTransitionSet().add(this.createTransition("yes", START_SPNEGO_AUTHENTICATE));
        evaluateClientRequest.getTransitionSet().add(this.createTransition("no", this.getStartState(flow)));
    }
}

