/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.nio.charset.Charset;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.support.spnego.authentication.principal.SpnegoCredential;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.web.flow.actions.AbstractNonInteractiveCredentialsAction;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.webflow.execution.RequestContext;

public class SpnegoCredentialsAction
extends AbstractNonInteractiveCredentialsAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpnegoCredentialsAction.class);
    private final boolean ntlm;
    private final String messageBeginPrefix;
    private boolean send401OnAuthenticationFailure = true;

    public SpnegoCredentialsAction(CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver, CasWebflowEventResolver serviceTicketRequestWebflowEventResolver, AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy, boolean ntlm, boolean send401OnAuthenticationFailure) {
        super(initialAuthenticationAttemptWebflowEventResolver, serviceTicketRequestWebflowEventResolver, adaptiveAuthenticationPolicy);
        this.ntlm = ntlm;
        this.messageBeginPrefix = (ntlm ? "NTLM" : "Negotiate") + ' ';
        this.send401OnAuthenticationFailure = send401OnAuthenticationFailure;
    }

    protected Credential constructCredentialsFromRequest(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        String authorizationHeader = request.getHeader("Authorization");
        LOGGER.debug("SPNEGO Authorization header located as [{}]", (Object)authorizationHeader);
        if (StringUtils.hasText((String)authorizationHeader) && authorizationHeader.startsWith(this.messageBeginPrefix) && authorizationHeader.length() > this.messageBeginPrefix.length()) {
            LOGGER.debug("SPNEGO Authorization header found with [{}] bytes", (Object)(authorizationHeader.length() - this.messageBeginPrefix.length()));
            byte[] token = EncodingUtils.decodeBase64((String)authorizationHeader.substring(this.messageBeginPrefix.length()));
            if (token == null) {
                LOGGER.warn("Could not decode authorization header in Base64");
                return null;
            }
            LOGGER.debug("Obtained token: [{}]. Creating SPNEGO credential...", (Object)new String(token, Charset.defaultCharset()));
            return new SpnegoCredential(token);
        }
        LOGGER.warn("SPNEGO Authorization header not found under [{}] or it does not begin with the prefix [{}]", (Object)"Authorization", (Object)this.messageBeginPrefix);
        return null;
    }

    protected void onError(RequestContext context) {
        this.setResponseHeader(context);
    }

    protected void onSuccess(RequestContext context) {
        this.setResponseHeader(context);
    }

    private void setResponseHeader(RequestContext context) {
        Credential credential = WebUtils.getCredential((RequestContext)context);
        if (credential == null) {
            LOGGER.debug("No credential was provided. No response header set.");
            return;
        }
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
        SpnegoCredential spnegoCredentials = (SpnegoCredential)credential;
        byte[] nextToken = spnegoCredentials.getNextToken();
        if (nextToken != null) {
            LOGGER.debug("Obtained output token: [{}]", (Object)new String(nextToken, Charset.defaultCharset()));
            response.setHeader("WWW-Authenticate", (this.ntlm ? "NTLM" : "Negotiate") + ' ' + EncodingUtils.encodeBase64((byte[])nextToken));
        } else {
            LOGGER.debug("Unable to obtain the output token required.");
        }
        if (spnegoCredentials.getPrincipal() == null && this.send401OnAuthenticationFailure) {
            LOGGER.debug("Setting HTTP Status to 401");
            response.setStatus(401);
        }
    }
}

