/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SpnegoNegociateCredentialsAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpnegoNegociateCredentialsAction.class);
    private final boolean ntlm;
    private final boolean mixedModeAuthentication;
    private final List<String> supportedBrowser;
    private final String messageBeginPrefix;

    public SpnegoNegociateCredentialsAction(List<String> supportedBrowser, boolean ntlm, boolean mixedModeAuthenticationEnabled) {
        this.ntlm = ntlm;
        this.messageBeginPrefix = this.constructMessagePrefix();
        this.mixedModeAuthentication = mixedModeAuthenticationEnabled;
        this.supportedBrowser = supportedBrowser;
        this.supportedBrowser.add("MSIE");
        this.supportedBrowser.add("Trident");
        this.supportedBrowser.add("Firefox");
        this.supportedBrowser.add("AppleWebKit");
    }

    protected Event doExecute(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
        String authorizationHeader = request.getHeader("Authorization");
        String userAgent = HttpRequestUtils.getHttpServletRequestUserAgent((HttpServletRequest)request);
        LOGGER.debug("Authorization header [{}], User Agent header [{}]", (Object)authorizationHeader, (Object)userAgent);
        if (!StringUtils.hasText((String)userAgent) || this.supportedBrowser.isEmpty()) {
            LOGGER.warn("User Agent header [{}] is empty, or no browsers are supported", (Object)userAgent);
            return this.error();
        }
        if (!this.isSupportedBrowser(userAgent)) {
            LOGGER.warn("User Agent header [{}] is not supported in the list of supported browsers [{}]", (Object)userAgent, this.supportedBrowser);
            return this.error();
        }
        if (!StringUtils.hasText((String)authorizationHeader) || !authorizationHeader.startsWith(this.messageBeginPrefix) || authorizationHeader.length() <= this.messageBeginPrefix.length()) {
            String wwwHeader = this.ntlm ? "NTLM" : "Negotiate";
            LOGGER.debug("Authorization header not found or does not match the message prefix [{}]. Sending [{}] header [{}]", new Object[]{this.messageBeginPrefix, "WWW-Authenticate", wwwHeader});
            response.setHeader("WWW-Authenticate", wwwHeader);
            response.setStatus(401);
            if (!this.mixedModeAuthentication) {
                LOGGER.debug("Mixed-mode authentication is disabled. Executing completion of response");
                context.getExternalContext().recordResponseComplete();
            } else {
                LOGGER.debug("Mixed-mode authentication is enabled");
            }
        }
        return this.success();
    }

    protected String constructMessagePrefix() {
        return (this.ntlm ? "NTLM" : "Negotiate") + ' ';
    }

    protected boolean isSupportedBrowser(String userAgent) {
        return this.supportedBrowser.stream().anyMatch(userAgent::contains);
    }
}

