/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.client;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apereo.cas.support.spnego.util.ReverseDNSRunnable;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class BaseSpnegoKnownClientSystemsFilterAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseSpnegoKnownClientSystemsFilterAction.class);
    private Pattern ipsToCheckPattern;
    private String alternativeRemoteHostAttribute;
    private long timeout;

    public BaseSpnegoKnownClientSystemsFilterAction(String ipsToCheckPattern) {
        this.setIpsToCheckPattern(ipsToCheckPattern);
    }

    public BaseSpnegoKnownClientSystemsFilterAction(String ipsToCheckPattern, String alternativeRemoteHostAttribute, long dnsTimeout) {
        this.setIpsToCheckPattern(ipsToCheckPattern);
        this.alternativeRemoteHostAttribute = alternativeRemoteHostAttribute;
        this.timeout = dnsTimeout;
    }

    protected Event doExecute(RequestContext context) {
        String remoteIp = this.getRemoteIp(context);
        LOGGER.debug("Current user IP [{}]", (Object)remoteIp);
        if (this.shouldDoSpnego(remoteIp)) {
            LOGGER.info("Spnego should be activated for [{}]", (Object)remoteIp);
            return this.yes();
        }
        LOGGER.info("Spnego should is skipped for [{}]", (Object)remoteIp);
        return this.no();
    }

    protected boolean shouldDoSpnego(String remoteIp) {
        return this.ipPatternCanBeChecked(remoteIp) && this.ipPatternMatches(remoteIp);
    }

    protected boolean ipPatternCanBeChecked(String remoteIp) {
        return this.ipsToCheckPattern != null && StringUtils.isNotBlank((CharSequence)remoteIp);
    }

    protected boolean ipPatternMatches(String remoteIp) {
        Matcher matcher = this.ipsToCheckPattern.matcher(remoteIp);
        if (matcher.find()) {
            LOGGER.debug("Remote IP address [{}] should be checked based on the defined pattern [{}]", (Object)remoteIp, (Object)this.ipsToCheckPattern.pattern());
            return true;
        }
        LOGGER.debug("No pattern or remote IP defined, or pattern does not match remote IP [{}]", (Object)remoteIp);
        return false;
    }

    private String getRemoteIp(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        String userAddress = request.getRemoteAddr();
        LOGGER.debug("Remote Address = [{}]", (Object)userAddress);
        if (StringUtils.isNotBlank((CharSequence)this.alternativeRemoteHostAttribute)) {
            userAddress = request.getHeader(this.alternativeRemoteHostAttribute);
            LOGGER.debug("Header Attribute [{}] = [{}]", (Object)this.alternativeRemoteHostAttribute, (Object)userAddress);
            if (StringUtils.isBlank((CharSequence)userAddress)) {
                userAddress = request.getRemoteAddr();
                LOGGER.warn("No value could be retrieved from the header [{}]. Falling back to [{}].", (Object)this.alternativeRemoteHostAttribute, (Object)userAddress);
            }
        }
        return userAddress;
    }

    public void setAlternativeRemoteHostAttribute(String alternativeRemoteHostAttribute) {
        this.alternativeRemoteHostAttribute = alternativeRemoteHostAttribute;
    }

    public void setIpsToCheckPattern(String ipsToCheckPattern) {
        this.ipsToCheckPattern = Pattern.compile(ipsToCheckPattern);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("ipsToCheckPattern", (Object)this.ipsToCheckPattern).append("alternativeRemoteHostAttribute", (Object)this.alternativeRemoteHostAttribute).append("timeout", this.timeout).toString();
    }

    protected String getRemoteHostName(String remoteIp) {
        ReverseDNSRunnable revDNS = new ReverseDNSRunnable(remoteIp);
        Thread t = new Thread((Runnable)revDNS);
        t.start();
        try {
            t.join(this.timeout);
        }
        catch (InterruptedException e) {
            LOGGER.debug("Threaded lookup failed.  Defaulting to IP [{}].", (Object)remoteIp, (Object)e);
        }
        String remoteHostName = revDNS.get();
        LOGGER.debug("Found remote host name [{}].", (Object)remoteHostName);
        return StringUtils.isNotBlank((CharSequence)remoteHostName) ? remoteHostName : remoteIp;
    }
}

