/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.client;

import java.util.regex.Pattern;
import org.apereo.cas.web.flow.client.BaseSpnegoKnownClientSystemsFilterAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostNameSpnegoKnownClientSystemsFilterAction
extends BaseSpnegoKnownClientSystemsFilterAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostNameSpnegoKnownClientSystemsFilterAction.class);
    private final Pattern hostNamePatternString;

    public HostNameSpnegoKnownClientSystemsFilterAction(String ipsToCheckPattern, String alternativeHost, long dnsTimeout, String hostNamePatternString) {
        super(ipsToCheckPattern, alternativeHost, dnsTimeout);
        this.hostNamePatternString = Pattern.compile(hostNamePatternString);
    }

    @Override
    protected boolean shouldDoSpnego(String remoteIp) {
        boolean ipCheck = this.ipPatternCanBeChecked(remoteIp);
        if (ipCheck && !this.ipPatternMatches(remoteIp)) {
            return false;
        }
        String hostName = this.getRemoteHostName(remoteIp);
        LOGGER.debug("Retrieved host name for the remote ip is [{}]", (Object)hostName);
        return this.hostNamePatternString.matcher(hostName).find();
    }
}

