/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.client;

import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.web.flow.client.BaseSpnegoKnownClientSystemsFilterAction;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.ResultCode;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapSpnegoKnownClientSystemsFilterAction
extends BaseSpnegoKnownClientSystemsFilterAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapSpnegoKnownClientSystemsFilterAction.class);
    private final String spnegoAttributeName;
    private final ConnectionFactory connectionFactory;
    private final SearchRequest searchRequest;

    public LdapSpnegoKnownClientSystemsFilterAction(String ipsToCheckPattern, String alternativeRemoteHostAttribute, long dnsTimeout, ConnectionFactory connectionFactory, SearchRequest searchRequest, String spnegoAttributeName) {
        super(ipsToCheckPattern, alternativeRemoteHostAttribute, dnsTimeout);
        this.connectionFactory = connectionFactory;
        this.spnegoAttributeName = spnegoAttributeName;
        this.searchRequest = searchRequest;
    }

    protected Connection createConnection() throws LdapException {
        LOGGER.debug("Establishing a connection...");
        Connection connection = this.connectionFactory.getConnection();
        connection.open();
        return connection;
    }

    @Override
    protected boolean shouldDoSpnego(String remoteIp) {
        if (StringUtils.isBlank((CharSequence)this.spnegoAttributeName)) {
            LOGGER.warn("Ignoring Spnego. Attribute name is not configured");
            return false;
        }
        if (this.connectionFactory == null) {
            LOGGER.warn("Ignoring Spnego. LDAP connection factory is not configured");
            return false;
        }
        if (this.searchRequest == null) {
            LOGGER.warn("Ignoring Spnego. LDAP search request is not configured");
            return false;
        }
        boolean ipCheck = this.ipPatternCanBeChecked(remoteIp);
        if (ipCheck && !this.ipPatternMatches(remoteIp)) {
            return false;
        }
        LOGGER.debug("Attempting to locate attribute [{}] for [{}]", (Object)this.spnegoAttributeName, (Object)remoteIp);
        return this.executeSearchForSpnegoAttribute(remoteIp);
    }

    @Override
    protected String getRemoteHostName(String remoteIp) {
        if ("localhost".equalsIgnoreCase(remoteIp) || remoteIp.startsWith("127.")) {
            return remoteIp;
        }
        return super.getRemoteHostName(remoteIp);
    }

    protected boolean executeSearchForSpnegoAttribute(String remoteIp) {
        Connection connection = null;
        String remoteHostName = this.getRemoteHostName(remoteIp);
        LOGGER.debug("Resolved remote hostname [{}] based on ip [{}]", (Object)remoteHostName, (Object)remoteIp);
        try {
            connection = this.createConnection();
            SearchOperation searchOperation = new SearchOperation(connection);
            this.searchRequest.getSearchFilter().setParameter(0, (Object)remoteHostName);
            LOGGER.debug("Using search filter [{}] on baseDn [{}]", (Object)this.searchRequest.getSearchFilter().format(), (Object)this.searchRequest.getBaseDn());
            Response searchResult = searchOperation.execute((Request)this.searchRequest);
            if (searchResult.getResultCode() == ResultCode.SUCCESS) {
                boolean bl = this.processSpnegoAttribute((Response<SearchResult>)searchResult);
                return bl;
            }
            try {
                throw new IllegalArgumentException("Failed to establish a connection ldap. " + searchResult.getMessage());
            }
            catch (LdapException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    protected boolean processSpnegoAttribute(Response<SearchResult> searchResult) {
        SearchResult result = (SearchResult)searchResult.getResult();
        if (result == null || result.getEntries().isEmpty()) {
            LOGGER.debug("Spnego attribute is not found in the search results");
            return false;
        }
        LdapEntry entry = result.getEntry();
        LdapAttribute attribute = entry.getAttribute(this.spnegoAttributeName);
        LOGGER.debug("Spnego attribute [{}] found as [{}] for [{}]", new Object[]{attribute.getName(), attribute.getStringValue(), entry.getDn()});
        return this.verifySpnegoAttributeValue(attribute);
    }

    protected boolean verifySpnegoAttributeValue(LdapAttribute attribute) {
        return attribute != null && StringUtils.isNotBlank((CharSequence)attribute.getStringValue());
    }
}

