/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.config;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.spnego.SpnegoProperties;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.web.flow.SpnegoCredentialsAction;
import org.apereo.cas.web.flow.SpnegoNegociateCredentialsAction;
import org.apereo.cas.web.flow.client.BaseSpnegoKnownClientSystemsFilterAction;
import org.apereo.cas.web.flow.client.HostNameSpnegoKnownClientSystemsFilterAction;
import org.apereo.cas.web.flow.client.LdapSpnegoKnownClientSystemsFilterAction;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchRequest;
import org.ldaptive.pool.PooledConnectionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.webflow.execution.Action;

@Configuration(value="spnegoWebflowActionsConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SpnegoWebflowActionsConfiguration {
    @Autowired
    @Qualifier(value="adaptiveAuthenticationPolicy")
    private AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy;
    @Autowired
    @Qualifier(value="serviceTicketRequestWebflowEventResolver")
    private CasWebflowEventResolver serviceTicketRequestWebflowEventResolver;
    @Autowired
    @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver")
    private CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver;
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    @RefreshScope
    public Action spnego() {
        SpnegoProperties spnegoProperties = this.casProperties.getAuthn().getSpnego();
        return new SpnegoCredentialsAction(this.initialAuthenticationAttemptWebflowEventResolver, this.serviceTicketRequestWebflowEventResolver, this.adaptiveAuthenticationPolicy, spnegoProperties.isNtlm(), spnegoProperties.isSend401OnAuthenticationFailure());
    }

    @Bean
    @RefreshScope
    public Action negociateSpnego() {
        SpnegoProperties spnegoProperties = this.casProperties.getAuthn().getSpnego();
        List<String> supportedBrowsers = Stream.of(spnegoProperties.getSupportedBrowsers().split(",")).collect(Collectors.toList());
        return new SpnegoNegociateCredentialsAction(supportedBrowsers, spnegoProperties.isNtlm(), spnegoProperties.isMixedModeAuthentication());
    }

    @Bean
    @RefreshScope
    public Action baseSpnegoClientAction() {
        SpnegoProperties spnegoProperties = this.casProperties.getAuthn().getSpnego();
        return new BaseSpnegoKnownClientSystemsFilterAction(spnegoProperties.getIpsToCheckPattern(), spnegoProperties.getAlternativeRemoteHostAttribute(), spnegoProperties.getDnsTimeout());
    }

    @Bean
    @RefreshScope
    public Action hostnameSpnegoClientAction() {
        SpnegoProperties spnegoProperties = this.casProperties.getAuthn().getSpnego();
        return new HostNameSpnegoKnownClientSystemsFilterAction(spnegoProperties.getIpsToCheckPattern(), spnegoProperties.getAlternativeRemoteHostAttribute(), spnegoProperties.getDnsTimeout(), spnegoProperties.getHostNamePatternString());
    }

    @Lazy
    @Bean
    @RefreshScope
    public Action ldapSpnegoClientAction() {
        SpnegoProperties spnegoProperties = this.casProperties.getAuthn().getSpnego();
        PooledConnectionFactory connectionFactory = LdapUtils.newLdaptivePooledConnectionFactory((AbstractLdapProperties)spnegoProperties.getLdap());
        SearchFilter filter = LdapUtils.newLdaptiveSearchFilter((String)spnegoProperties.getLdap().getSearchFilter(), (String)"host", new ArrayList(0));
        SearchRequest searchRequest = LdapUtils.newLdaptiveSearchRequest((String)spnegoProperties.getLdap().getBaseDn(), (SearchFilter)filter);
        return new LdapSpnegoKnownClientSystemsFilterAction(spnegoProperties.getIpsToCheckPattern(), spnegoProperties.getAlternativeRemoteHostAttribute(), spnegoProperties.getDnsTimeout(), (ConnectionFactory)connectionFactory, searchRequest, spnegoProperties.getSpnegoAttributeName());
    }
}

