/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.HandlerResult;
import org.apereo.cas.config.CasCoreAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationHandlersConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationMetadataConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPolicyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPrincipalConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationSupportConfiguration;
import org.apereo.cas.config.CasCoreHttpConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasPersonDirectoryConfiguration;
import org.apereo.cas.config.StormpathAuthenticationConfiguration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.test.annotation.IfProfileValue;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={StormpathAuthenticationConfiguration.class, CasCoreAuthenticationConfiguration.class, CasCoreAuthenticationPrincipalConfiguration.class, CasCoreAuthenticationPolicyConfiguration.class, CasCoreAuthenticationMetadataConfiguration.class, CasCoreAuthenticationSupportConfiguration.class, CasCoreAuthenticationHandlersConfiguration.class, CasCoreHttpConfiguration.class, CasCoreUtilConfiguration.class, CasPersonDirectoryConfiguration.class, CasCoreServicesConfiguration.class, RefreshAutoConfiguration.class})
@TestPropertySource(locations={"classpath:/stormpath.properties"})
@EnableScheduling
@IfProfileValue(name="stormpath")
public class StormpathAuthenticationHandlerTests {
    @Autowired
    @Qualifier(value="stormpathAuthenticationHandler")
    private AuthenticationHandler authenticationHandler;

    @Before
    public void setUp() {
        RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletRequestAttributes((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse()));
    }

    @Test
    public void verifyAuthentication() throws Exception {
        HandlerResult result = this.authenticationHandler.authenticate((Credential)CoreAuthenticationTestUtils.getCredentialsWithDifferentUsernameAndPassword((String)"casuser", (String)"12345678mM"));
        Assert.assertEquals((Object)result.getPrincipal().getId(), (Object)"casuser");
        Assert.assertTrue((boolean)result.getPrincipal().getAttributes().containsKey("fullName"));
        Assert.assertTrue((boolean)result.getPrincipal().getAttributes().containsKey("email"));
    }
}

