/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.StormpathAuthenticationHandler;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.stormpath.StormpathProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="stormpathAuthenticationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class StormpathAuthenticationConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;

    @ConditionalOnMissingBean(name={"stormpathPrincipalFactory"})
    @Bean
    public PrincipalFactory stormpathPrincipalFactory() {
        return new DefaultPrincipalFactory();
    }

    @Bean
    public AuthenticationHandler stormpathAuthenticationHandler() {
        StormpathProperties stormpath = this.casProperties.getAuthn().getStormpath();
        StormpathAuthenticationHandler handler = new StormpathAuthenticationHandler(stormpath.getName(), this.servicesManager, this.stormpathPrincipalFactory(), null, stormpath.getApiKey(), stormpath.getApplicationId(), stormpath.getSecretkey());
        handler.setPasswordEncoder(Beans.newPasswordEncoder((PasswordEncoderProperties)stormpath.getPasswordEncoder()));
        handler.setPrincipalNameTransformer(Beans.newPrincipalNameTransformer((PrincipalTransformationProperties)stormpath.getPrincipalTransformation()));
        return handler;
    }

    @Configuration(value="stormpathAuthenticationEventExecutionPlanConfiguration")
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public class StormpathAuthenticationEventExecutionPlanConfiguration
    implements AuthenticationEventExecutionPlanConfigurer {
        @Autowired
        @Qualifier(value="personDirectoryPrincipalResolver")
        private PrincipalResolver personDirectoryPrincipalResolver;

        public void configureAuthenticationExecutionPlan(AuthenticationEventExecutionPlan plan) {
            StormpathProperties stormpath = StormpathAuthenticationConfiguration.this.casProperties.getAuthn().getStormpath();
            if (StringUtils.isNotBlank((CharSequence)stormpath.getApiKey()) && StringUtils.isNotBlank((CharSequence)stormpath.getSecretkey())) {
                plan.registerAuthenticationHandlerWithPrincipalResolver(StormpathAuthenticationConfiguration.this.stormpathAuthenticationHandler(), this.personDirectoryPrincipalResolver);
            }
        }
    }
}

