/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web;

import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.BaseThemeTests;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.test.CasTestExtension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.ui.context.Theme;
import org.springframework.ui.context.ThemeSource;

@Tag(value="Web")
@SpringBootTest(classes={BaseThemeTests.SharedTestConfiguration.class}, properties={"cas.view.theme-source-type=AGGREGATE", "cas.view.template-prefixes[0]=classpath:/ext-templates", "cas.view.template-prefixes[1]=classpath:/more-ext-templates"})
@ExtendWith(value={CasTestExtension.class})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
class AggregateCasThemeSourceTests {
    @Autowired
    @Qualifier(value="themeSource")
    private ThemeSource themeSource;

    AggregateCasThemeSourceTests() {
    }

    @Test
    void verifyCustomSource() {
        Theme theme = this.themeSource.getTheme("my-theme");
        Assertions.assertNotNull((Object)theme);
        String message = theme.getMessageSource().getMessage("cas.theme.name", ArrayUtils.EMPTY_OBJECT_ARRAY, Locale.ENGLISH);
        Assertions.assertEquals((Object)"MyTheme2", (Object)message);
        String message2 = theme.getMessageSource().getMessage("screen.welcome.instructions", ArrayUtils.EMPTY_OBJECT_ARRAY, Locale.ENGLISH);
        Assertions.assertEquals((Object)"Test123", (Object)message2);
    }
}

