/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apereo.cas.BaseThemeTests;
import org.apereo.cas.authentication.principal.AbstractWebApplicationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.test.CasTestExtension;
import org.apereo.cas.util.MockRequestContext;
import org.apereo.cas.util.MockWebServer;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.core.io.ClassPathResource;
import org.springframework.webflow.execution.RequestContext;

@Tag(value="Web")
class RegisteredServiceThemeResolverTests {
    RegisteredServiceThemeResolverTests() {
    }

    @SpringBootTest(classes={BaseThemeTests.SharedTestConfiguration.class}, properties={"cas.theme.default-theme-name=example"})
    @Nested
    @ExtendWith(value={CasTestExtension.class})
    class ExampleThemeTests
    extends BaseThemeTests {
        ExampleThemeTests(RegisteredServiceThemeResolverTests this$0) {
        }

        @Test
        void verifyNoAccess() throws Throwable {
            MockRequestContext context = MockRequestContext.create();
            context.withUserAgent();
            CasRegisteredService registeredService = RegisteredServiceTestUtils.getRegisteredService((String)UUID.randomUUID().toString());
            DefaultRegisteredServiceAccessStrategy strategy = new DefaultRegisteredServiceAccessStrategy(false, true);
            registeredService.setAccessStrategy((RegisteredServiceAccessStrategy)strategy);
            this.servicesManager.save((RegisteredService)registeredService);
            AbstractWebApplicationService service = RegisteredServiceTestUtils.getService();
            WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)service);
            Assertions.assertEquals((Object)"example", (Object)this.themeResolver.resolveThemeName((HttpServletRequest)context.getHttpServletRequest()));
        }

        @Test
        void verifyNoTheme() throws Throwable {
            MockRequestContext context = MockRequestContext.create();
            CasRegisteredService registeredService = RegisteredServiceTestUtils.getRegisteredService((String)UUID.randomUUID().toString());
            registeredService.setTheme(null);
            this.servicesManager.save((RegisteredService)registeredService);
            AbstractWebApplicationService service = RegisteredServiceTestUtils.getService();
            WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)service);
            Assertions.assertEquals((Object)"example", (Object)this.themeResolver.resolveThemeName((HttpServletRequest)context.getHttpServletRequest()));
        }

        @Test
        void verifyGroovyTheme() throws Throwable {
            MockRequestContext context = MockRequestContext.create();
            CasRegisteredService registeredService = RegisteredServiceTestUtils.getRegisteredService((String)UUID.randomUUID().toString());
            File file = File.createTempFile("Theme", ".groovy");
            String script = IOUtils.toString((InputStream)new ClassPathResource("GroovyTheme.groovy").getInputStream(), (Charset)StandardCharsets.UTF_8);
            FileUtils.writeStringToFile((File)file, (String)script, (Charset)StandardCharsets.UTF_8);
            registeredService.setTheme(file.getCanonicalPath());
            this.servicesManager.save((RegisteredService)registeredService);
            AbstractWebApplicationService service = RegisteredServiceTestUtils.getService((String)registeredService.getServiceId());
            WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)service);
            Assertions.assertEquals((Object)"some-theme", (Object)this.themeResolver.resolveThemeName((HttpServletRequest)context.getHttpServletRequest()));
        }

        @Test
        void verifyUrlTheme() throws Throwable {
            try (MockWebServer webServer = new MockWebServer("custom-theme");){
                webServer.start();
                MockRequestContext context = MockRequestContext.create();
                CasRegisteredService registeredService = RegisteredServiceTestUtils.getRegisteredService((String)UUID.randomUUID().toString());
                registeredService.setTheme("http://localhost:%s".formatted(webServer.getPort()));
                this.servicesManager.save((RegisteredService)registeredService);
                AbstractWebApplicationService service = RegisteredServiceTestUtils.getService((String)registeredService.getServiceId());
                WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)service);
                Assertions.assertDoesNotThrow(() -> this.themeResolver.setThemeName((HttpServletRequest)context.getHttpServletRequest(), (HttpServletResponse)context.getHttpServletResponse(), "whatever"));
                Assertions.assertEquals((Object)"custom-theme", (Object)this.themeResolver.resolveThemeName((HttpServletRequest)context.getHttpServletRequest()));
            }
        }

        @Test
        void verifyCustomTheme() throws Throwable {
            MockRequestContext context = MockRequestContext.create();
            CasRegisteredService registeredService = RegisteredServiceTestUtils.getRegisteredService((String)UUID.randomUUID().toString());
            registeredService.setTheme("custom-theme");
            this.servicesManager.save((RegisteredService)registeredService);
            AbstractWebApplicationService service = RegisteredServiceTestUtils.getService((String)registeredService.getServiceId());
            WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)service);
            Assertions.assertEquals((Object)"custom-theme", (Object)this.themeResolver.resolveThemeName((HttpServletRequest)context.getHttpServletRequest()));
        }
    }

    @SpringBootTest(classes={BaseThemeTests.SharedTestConfiguration.class}, properties={"cas.view.template-prefixes[0]=classpath:/ext-templates", "cas.theme.default-theme-name=example"})
    @Nested
    @ExtendWith(value={CasTestExtension.class})
    class ExternalThemeTests
    extends BaseThemeTests {
        ExternalThemeTests(RegisteredServiceThemeResolverTests this$0) {
        }

        @Test
        void verifyCustomSource() throws Throwable {
            MockRequestContext context = MockRequestContext.create();
            CasRegisteredService registeredService = RegisteredServiceTestUtils.getRegisteredService((String)UUID.randomUUID().toString());
            registeredService.setTheme("my-theme");
            this.servicesManager.save((RegisteredService)registeredService);
            AbstractWebApplicationService service = RegisteredServiceTestUtils.getService((String)registeredService.getServiceId());
            WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)service);
            Assertions.assertEquals((Object)"my-theme", (Object)this.themeResolver.resolveThemeName((HttpServletRequest)context.getHttpServletRequest()));
        }
    }
}

