/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web;

import jakarta.servlet.http.HttpServletRequest;
import org.apereo.cas.BaseThemeTests;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.test.CasTestExtension;
import org.apereo.cas.util.MockRequestContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.web.servlet.ThemeResolver;

@SpringBootTest(classes={BaseThemeTests.SharedTestConfiguration.class}, properties={"cas.view.template-prefixes[0]=file:///etc/cas/templates", "cas.theme.default-theme-name=test"})
@Tag(value="Web")
@ExtendWith(value={CasTestExtension.class})
class ServiceThemeResolverTests {
    private static final String MOZILLA = "Mozilla";
    private static final String DEFAULT_THEME_NAME = "test";
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="themeResolver")
    private ThemeResolver themeResolver;

    ServiceThemeResolverTests() {
    }

    @Test
    void verifyGetServiceThemeDoesNotExist() throws Throwable {
        CasRegisteredService registeredService = new CasRegisteredService();
        registeredService.setTheme("myTheme");
        registeredService.setId(1000L);
        registeredService.setName("Test Service");
        registeredService.setServiceId("myServiceId");
        this.servicesManager.save((RegisteredService)registeredService);
        MockRequestContext context = MockRequestContext.create();
        context.getFlowScope().put("service", (Object)RegisteredServiceTestUtils.getService((String)registeredService.getServiceId()));
        context.withUserAgent();
        Assertions.assertEquals((Object)DEFAULT_THEME_NAME, (Object)this.themeResolver.resolveThemeName((HttpServletRequest)context.getHttpServletRequest()));
    }

    @Test
    void verifyGetDefaultService() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("service", "myServiceId");
        request.addHeader("User-Agent", (Object)MOZILLA);
        Assertions.assertEquals((Object)DEFAULT_THEME_NAME, (Object)this.themeResolver.resolveThemeName((HttpServletRequest)request));
    }
}

