/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support;

import java.sql.Timestamp;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.web.support.AbstractThrottledSubmissionHandlerInterceptorAdapter;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter
extends AbstractThrottledSubmissionHandlerInterceptorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter.class);
    private static final double NUMBER_OF_MILLISECONDS_IN_SECOND = 1000.0;
    private static final String INSPEKTR_ACTION_THROTTLED = "THROTTLED_LOGIN_ATTEMPT";
    private static final String INSPEKTR_ACTION_FAILED = "FAILED_LOGIN_ATTEMPT";
    private final AuditTrailManager auditTrailManager;
    private final DataSource dataSource;
    private final String applicationCode;
    private final String authenticationFailureCode;
    private final String sqlQueryAudit;
    private JdbcTemplate jdbcTemplate;

    public InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter(int failureThreshold, int failureRangeInSeconds, String usernameParameter, AuditTrailManager auditTrailManager, DataSource dataSource, String appCode, String sqlQueryAudit, String authenticationFailureCode) {
        super(failureThreshold, failureRangeInSeconds, usernameParameter);
        this.auditTrailManager = auditTrailManager;
        this.dataSource = dataSource;
        this.applicationCode = appCode;
        this.sqlQueryAudit = sqlQueryAudit;
        this.authenticationFailureCode = authenticationFailureCode;
        if (this.dataSource != null) {
            this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        } else {
            LOGGER.warn("No data source is defined for [{}]. Ignoring the construction of JDBC template", (Object)this.getName());
        }
    }

    public boolean exceedsThreshold(HttpServletRequest request) {
        if (this.dataSource != null && this.jdbcTemplate != null) {
            String userToUse = InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter.constructUsername(request, this.getUsernameParameter());
            ZonedDateTime cutoff = ZonedDateTime.now(ZoneOffset.UTC).minusSeconds(this.getFailureRangeInSeconds());
            ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
            String remoteAddress = clientInfo.getClientIpAddress();
            List failures = this.jdbcTemplate.query(this.sqlQueryAudit, new Object[]{remoteAddress, userToUse, this.authenticationFailureCode, this.applicationCode, DateTimeUtils.timestampOf((ChronoZonedDateTime)cutoff)}, new int[]{12, 12, 12, 12, 93}, (resultSet, i) -> resultSet.getTimestamp(1));
            if (failures.size() < 2) {
                return false;
            }
            return 1000.0 / (double)(((Timestamp)failures.get(0)).getTime() - ((Timestamp)failures.get(1)).getTime()) > this.getThresholdRate();
        }
        LOGGER.warn("No data source is defined for [{}]. Ignoring threshold checking", (Object)this.getName());
        return false;
    }

    public void recordSubmissionFailure(HttpServletRequest request) {
        super.recordSubmissionFailure(request);
        this.recordAnyAction(request, INSPEKTR_ACTION_FAILED, "recordSubmissionFailure()");
    }

    protected void recordThrottle(HttpServletRequest request) {
        super.recordThrottle(request);
        this.recordAnyAction(request, INSPEKTR_ACTION_THROTTLED, "recordThrottle()");
    }

    protected void recordAnyAction(HttpServletRequest request, String actionName, String methodName) {
        if (this.dataSource != null && this.jdbcTemplate != null) {
            String userToUse = InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter.constructUsername(request, this.getUsernameParameter());
            ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
            AuditActionContext context = new AuditActionContext(userToUse, userToUse, actionName, this.applicationCode, DateTimeUtils.dateOf((ChronoZonedDateTime)ZonedDateTime.now(ZoneOffset.UTC)), clientInfo.getClientIpAddress(), clientInfo.getServerIpAddress());
            this.auditTrailManager.record(context);
        } else {
            LOGGER.warn("No data source is defined for [{}]. Ignoring audit record-keeping", (Object)this.getName());
        }
    }

    private static String constructUsername(HttpServletRequest request, String usernameParameter) {
        return request.getParameter(usernameParameter);
    }

    public String getName() {
        return "inspektrIpAddressUsernameThrottle";
    }
}

