/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support.config;

import javax.sql.DataSource;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.throttle.ThrottleProperties;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.web.support.InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter;
import org.apereo.cas.web.support.ThrottledSubmissionHandlerInterceptor;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casJdbcThrottlingConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasJdbcThrottlingConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    public DataSource inspektrAuditTrailDataSource() {
        return JpaBeans.newDataSource((AbstractJpaProperties)this.casProperties.getAuthn().getThrottle().getJdbc());
    }

    @Autowired
    @Bean
    @RefreshScope
    public ThrottledSubmissionHandlerInterceptor authenticationThrottle(@Qualifier(value="auditTrailManager") AuditTrailManager auditTrailManager) {
        ThrottleProperties throttle = this.casProperties.getAuthn().getThrottle();
        String appcode = throttle.getAppcode();
        String sqlQueryAudit = throttle.getJdbc().getAuditQuery();
        ThrottleProperties.Failure failure = throttle.getFailure();
        return new InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter(failure.getThreshold(), failure.getRangeSeconds(), throttle.getUsernameParameter(), auditTrailManager, this.inspektrAuditTrailDataSource(), appcode, sqlQueryAudit, failure.getCode());
    }
}

