/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import javax.net.ssl.SSLContext;
import org.apereo.cas.audit.AuditTrailExecutionPlan;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.audit.AuditMongoDbProperties;
import org.apereo.cas.configuration.model.support.mongo.BaseMongoDbProperties;
import org.apereo.cas.configuration.model.support.throttle.ThrottleProperties;
import org.apereo.cas.mongo.MongoDbConnectionFactory;
import org.apereo.cas.throttle.ThrottledRequestExecutor;
import org.apereo.cas.throttle.ThrottledRequestResponseHandler;
import org.apereo.cas.web.support.MongoDbThrottledSubmissionHandlerInterceptorAdapter;
import org.apereo.cas.web.support.ThrottledSubmissionHandlerConfigurationContext;
import org.apereo.cas.web.support.ThrottledSubmissionHandlerInterceptor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;

@Configuration(value="casMongoDbThrottlingConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasMongoDbThrottlingConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="throttledRequestResponseHandler")
    private ObjectProvider<ThrottledRequestResponseHandler> throttledRequestResponseHandler;
    @Autowired
    @Qualifier(value="throttledRequestExecutor")
    private ObjectProvider<ThrottledRequestExecutor> throttledRequestExecutor;
    @Autowired
    @Qualifier(value="sslContext")
    private ObjectProvider<SSLContext> sslContext;

    @Autowired
    @Bean
    @RefreshScope
    public ThrottledSubmissionHandlerInterceptor authenticationThrottle(@Qualifier(value="auditTrailExecutionPlan") AuditTrailExecutionPlan auditTrailExecutionPlan) {
        ThrottleProperties throttle = this.casProperties.getAuthn().getThrottle();
        ThrottleProperties.Failure failure = throttle.getFailure();
        AuditMongoDbProperties mongo = this.casProperties.getAudit().getMongo();
        MongoDbConnectionFactory factory = new MongoDbConnectionFactory((SSLContext)this.sslContext.getObject());
        MongoTemplate mongoTemplate = factory.buildMongoTemplate((BaseMongoDbProperties)mongo);
        MongoDbConnectionFactory.createCollection((MongoOperations)mongoTemplate, (String)mongo.getCollection(), (boolean)mongo.isDropCollection());
        ThrottledSubmissionHandlerConfigurationContext context = ThrottledSubmissionHandlerConfigurationContext.builder().failureThreshold(failure.getThreshold()).failureRangeInSeconds(failure.getRangeSeconds()).usernameParameter(throttle.getUsernameParameter()).authenticationFailureCode(failure.getCode()).auditTrailExecutionPlan(auditTrailExecutionPlan).applicationCode(throttle.getAppCode()).throttledRequestResponseHandler((ThrottledRequestResponseHandler)this.throttledRequestResponseHandler.getObject()).throttledRequestExecutor((ThrottledRequestExecutor)this.throttledRequestExecutor.getObject()).build();
        return new MongoDbThrottledSubmissionHandlerInterceptorAdapter(context, mongoTemplate, mongo.getCollection());
    }
}

