/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support;

import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.web.support.AbstractInspektrAuditHandlerInterceptorAdapter;
import org.apereo.cas.web.support.ThrottledSubmissionHandlerConfigurationContext;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class MongoDbThrottledSubmissionHandlerInterceptorAdapter
extends AbstractInspektrAuditHandlerInterceptorAdapter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbThrottledSubmissionHandlerInterceptorAdapter.class);
    private final transient MongoTemplate mongoTemplate;
    private final String collectionName;

    public MongoDbThrottledSubmissionHandlerInterceptorAdapter(ThrottledSubmissionHandlerConfigurationContext configurationContext, MongoTemplate mongoTemplate, String collectionName) {
        super(configurationContext);
        this.mongoTemplate = mongoTemplate;
        this.collectionName = collectionName;
    }

    public boolean exceedsThreshold(HttpServletRequest request) {
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        String remoteAddress = clientInfo.getClientIpAddress();
        Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"clientIpAddress").is((Object)remoteAddress).and("principal").is((Object)this.getUsernameParameterFromRequest(request)).and("actionPerformed").is((Object)this.getConfigurationContext().getAuthenticationFailureCode()).and("applicationCode").is((Object)this.getConfigurationContext().getApplicationCode()).and("whenActionWasPerformed").gte((Object)this.getFailureInRangeCutOffDate()));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"whenActionWasPerformed"}));
        query.limit(2);
        query.fields().include("whenActionWasPerformed");
        LOGGER.debug("Executing MongoDb throttling query [{}]", (Object)query.toString());
        List failures = this.mongoTemplate.find(query, AuditActionContext.class, this.collectionName).stream().map(AuditActionContext::getWhenActionWasPerformed).collect(Collectors.toList());
        return this.calculateFailureThresholdRateAndCompare(failures);
    }

    public String getName() {
        return "MongoDbThrottle";
    }
}

