/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.audit.AuditMongoDbProperties;
import org.apereo.cas.configuration.model.support.mongo.BaseMongoDbProperties;
import org.apereo.cas.mongo.CasMongoOperations;
import org.apereo.cas.mongo.MongoDbConnectionFactory;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.support.MongoDbThrottledSubmissionHandlerInterceptorAdapter;
import org.apereo.cas.web.support.ThrottledSubmissionHandlerConfigurationContext;
import org.apereo.cas.web.support.ThrottledSubmissionHandlerInterceptor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.data.mongodb.core.MongoOperations;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.Throttling, module="mongo")
@AutoConfiguration
public class CasMongoDbThrottlingConfiguration {
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public ThrottledSubmissionHandlerInterceptor authenticationThrottle(CasConfigurationProperties casProperties, @Qualifier(value="authenticationThrottlingConfigurationContext") ThrottledSubmissionHandlerConfigurationContext authenticationThrottlingConfigurationContext, @Qualifier(value="casSslContext") CasSSLContext casSslContext) {
        AuditMongoDbProperties mongo = casProperties.getAudit().getMongo();
        MongoDbConnectionFactory factory = new MongoDbConnectionFactory(casSslContext.getSslContext());
        CasMongoOperations mongoTemplate = factory.buildMongoTemplate((BaseMongoDbProperties)mongo);
        MongoDbConnectionFactory.createCollection((MongoOperations)mongoTemplate, (String)mongo.getCollection(), (boolean)mongo.isDropCollection());
        return new MongoDbThrottledSubmissionHandlerInterceptorAdapter(authenticationThrottlingConfigurationContext, (MongoOperations)mongoTemplate, mongo.getCollection());
    }
}

