/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support;

import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.configuration.model.support.throttle.ThrottleProperties;
import org.apereo.cas.web.support.AbstractInspektrAuditHandlerInterceptorAdapter;
import org.apereo.cas.web.support.ThrottledSubmissionHandlerConfigurationContext;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class MongoDbThrottledSubmissionHandlerInterceptorAdapter
extends AbstractInspektrAuditHandlerInterceptorAdapter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbThrottledSubmissionHandlerInterceptorAdapter.class);
    private final MongoOperations mongoTemplate;
    private final String collectionName;

    public MongoDbThrottledSubmissionHandlerInterceptorAdapter(ThrottledSubmissionHandlerConfigurationContext configurationContext, MongoOperations mongoTemplate, String collectionName) {
        super(configurationContext);
        this.mongoTemplate = mongoTemplate;
        this.collectionName = collectionName;
    }

    public boolean exceedsThreshold(HttpServletRequest request) {
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        String remoteAddress = clientInfo.getClientIpAddress();
        ThrottleProperties throttle = this.getConfigurationContext().getCasProperties().getAuthn().getThrottle();
        Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"clientIpAddress").is((Object)remoteAddress).and("principal").is((Object)this.getUsernameParameterFromRequest(request)).and("actionPerformed").is((Object)throttle.getFailure().getCode()).and("applicationCode").is((Object)throttle.getCore().getAppCode()).and("whenActionWasPerformed").gte((Object)this.getFailureInRangeCutOffDate()));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"whenActionWasPerformed"}));
        query.limit(2);
        query.fields().include("whenActionWasPerformed");
        LOGGER.debug("Executing MongoDb throttling query [{}]", (Object)query);
        List failures = this.mongoTemplate.find(query, AuditActionContext.class, this.collectionName).stream().map(arg_0 -> ((MongoDbThrottledSubmissionHandlerInterceptorAdapter)this).toThrottledSubmission(arg_0)).collect(Collectors.toList());
        return this.calculateFailureThresholdRateAndCompare(failures);
    }

    public String getName() {
        return "MongoDbThrottle";
    }
}

