/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.authentication.api;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Entity
@Table(name="MultifactorAuthenticationTrustRecord")
@JsonIgnoreProperties(ignoreUnknown=true)
public class MultifactorAuthenticationTrustRecord
implements Comparable<MultifactorAuthenticationTrustRecord> {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id = Integer.MAX_VALUE;
    @Column(updatable=true, insertable=true, nullable=false)
    private String principal;
    @Column(updatable=true, insertable=true, nullable=false)
    private String geography;
    @Column(nullable=false, columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private LocalDate date;
    @Column(updatable=true, insertable=true, nullable=false)
    private String key;
    @Column(updatable=true, insertable=true, nullable=false)
    private String name;

    public String getKey() {
        return this.key;
    }

    public void setKey(String id) {
        this.key = id;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public String getGeography() {
        return this.geography;
    }

    public void setGeography(String geography) {
        this.geography = geography;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        MultifactorAuthenticationTrustRecord rhs = (MultifactorAuthenticationTrustRecord)obj;
        return new EqualsBuilder().append((Object)this.principal, (Object)rhs.principal).append((Object)this.geography, (Object)rhs.geography).append((Object)this.date, (Object)rhs.date).append((Object)this.key, (Object)rhs.key).append((Object)this.name, (Object)rhs.name).isEquals();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.principal).append((Object)this.geography).append((Object)this.date).append((Object)this.key).append((Object)this.name).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE).append("principal", (Object)this.principal).append("geography", (Object)this.geography).append("date", (Object)this.date).append("name", (Object)this.name).toString();
    }

    public static MultifactorAuthenticationTrustRecord newInstance(String principal, String geography) {
        MultifactorAuthenticationTrustRecord r = new MultifactorAuthenticationTrustRecord();
        r.setDate(LocalDate.now());
        r.setPrincipal(principal);
        r.setGeography(geography);
        r.setName(principal.concat("-").concat(LocalDate.now().toString()).concat("-").concat(geography));
        return r;
    }

    @Override
    public int compareTo(MultifactorAuthenticationTrustRecord o) {
        return this.date.compareTo(o.getDate());
    }
}

