/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.authentication.storage;

import java.time.LocalDate;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecord;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.trusted.util.MultifactorAuthenticationTrustUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Transactional;

@EnableTransactionManagement(proxyTargetClass=true)
@Transactional(readOnly=false, transactionManager="transactionManagerMfaAuthnTrust")
public abstract class BaseMultifactorAuthenticationTrustStorage
implements MultifactorAuthenticationTrustStorage {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private CipherExecutor<String, String> cipherExecutor;

    @Override
    @Audit(action="TRUSTED_AUTHENTICATION", actionResolverName="TRUSTED_AUTHENTICATION_ACTION_RESOLVER", resourceResolverName="TRUSTED_AUTHENTICATION_RESOURCE_RESOLVER")
    public MultifactorAuthenticationTrustRecord set(MultifactorAuthenticationTrustRecord record) {
        this.logger.debug("Stored authentication trust record for {}", (Object)record);
        record.setKey(this.generateKey(record));
        return this.setInternal(record);
    }

    @Override
    public Set<MultifactorAuthenticationTrustRecord> get(String principal, LocalDate onOrAfterDate) {
        Set<MultifactorAuthenticationTrustRecord> res = this.get(principal);
        res.removeIf(entry -> {
            if (entry.getDate().isBefore(onOrAfterDate)) {
                return true;
            }
            String decodedKey = (String)this.cipherExecutor.decode((Object)entry.getKey());
            String currentKey = MultifactorAuthenticationTrustUtils.generateKey(entry);
            if (StringUtils.isBlank((String)decodedKey)) {
                return true;
            }
            return !decodedKey.equals(currentKey);
        });
        return res;
    }

    protected String generateKey(MultifactorAuthenticationTrustRecord r) {
        return (String)this.cipherExecutor.encode((Object)MultifactorAuthenticationTrustUtils.generateKey(r));
    }

    public void setCipherExecutor(CipherExecutor<String, String> cipherExecutor) {
        this.cipherExecutor = cipherExecutor;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected abstract MultifactorAuthenticationTrustRecord setInternal(MultifactorAuthenticationTrustRecord var1);
}

