/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.authentication.storage;

import com.google.common.cache.LoadingCache;
import java.time.LocalDate;
import java.util.Set;
import java.util.stream.Collectors;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecord;
import org.apereo.cas.trusted.authentication.storage.BaseMultifactorAuthenticationTrustStorage;

public class InMemoryMultifactorAuthenticationTrustStorage
extends BaseMultifactorAuthenticationTrustStorage {
    private LoadingCache<String, MultifactorAuthenticationTrustRecord> storage;

    public InMemoryMultifactorAuthenticationTrustStorage(LoadingCache<String, MultifactorAuthenticationTrustRecord> st) {
        this.storage = st;
    }

    @Override
    public void expire(String key) {
        this.storage.asMap().keySet().removeIf(k -> k.equalsIgnoreCase(key));
    }

    @Override
    public void expire(LocalDate onOrBefore) {
        Set<MultifactorAuthenticationTrustRecord> results = this.storage.asMap().values().stream().filter(entry -> entry.getDate().isEqual(onOrBefore) || entry.getDate().isBefore(onOrBefore)).sorted().distinct().collect(Collectors.toSet());
        this.logger.info("Found {} expired records", (Object)results.size());
        if (!results.isEmpty()) {
            results.forEach(entry -> this.storage.invalidate((Object)entry.getKey()));
            this.logger.info("Invalidated and removed {} expired records", (Object)results.size());
        }
    }

    @Override
    public Set<MultifactorAuthenticationTrustRecord> get(LocalDate onOrAfterDate) {
        this.expire(onOrAfterDate);
        return this.storage.asMap().values().stream().filter(entry -> entry.getDate().isEqual(onOrAfterDate) || entry.getDate().isAfter(onOrAfterDate)).sorted().distinct().collect(Collectors.toSet());
    }

    @Override
    public Set<MultifactorAuthenticationTrustRecord> get(String principal) {
        return this.storage.asMap().values().stream().filter(entry -> entry.getPrincipal().equalsIgnoreCase(principal)).sorted().distinct().collect(Collectors.toSet());
    }

    @Override
    public MultifactorAuthenticationTrustRecord setInternal(MultifactorAuthenticationTrustRecord record) {
        this.storage.put((Object)record.getKey(), (Object)record);
        return record;
    }
}

