/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.web.flow;

import org.apache.commons.lang.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CurrentCredentialsAndAuthentication;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecord;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.trusted.util.MultifactorAuthenticationTrustUtils;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class MultifactorAuthenticationSetTrustAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthenticationSetTrustAction.class);
    private static final String PARAM_NAME_DEVICE_NAME = "deviceName";
    private MultifactorAuthenticationTrustStorage storage;
    private String mfaTrustedAuthnAttributeName;

    public Event doExecute(RequestContext requestContext) throws Exception {
        Authentication c = WebUtils.getAuthentication((RequestContext)requestContext);
        if (c == null) {
            LOGGER.error("Could not determine authentication from the request context");
            return this.error();
        }
        CurrentCredentialsAndAuthentication.bindCurrent((Authentication)c);
        String principal = c.getPrincipal().getId();
        if (!requestContext.getFlashScope().contains("mfaTrustedAuthentication")) {
            String deviceName;
            LOGGER.debug("Attempt to store trusted authentication record for {}", (Object)principal);
            MultifactorAuthenticationTrustRecord record = MultifactorAuthenticationTrustRecord.newInstance(principal, MultifactorAuthenticationTrustUtils.generateGeography());
            if (requestContext.getRequestParameters().contains(PARAM_NAME_DEVICE_NAME) && StringUtils.isNotBlank((String)(deviceName = requestContext.getRequestParameters().get(PARAM_NAME_DEVICE_NAME)))) {
                record.setName(deviceName);
            }
            this.storage.set(record);
            LOGGER.debug("Saved trusted authentication record for {} under {}", (Object)principal, (Object)record.getName());
        }
        LOGGER.debug("Trusted authentication session exists for {}", (Object)principal);
        if (StringUtils.isNotBlank((String)this.mfaTrustedAuthnAttributeName) && !c.getAttributes().containsKey(this.mfaTrustedAuthnAttributeName)) {
            Authentication newAuthn = DefaultAuthenticationBuilder.newInstance((Authentication)c).addAttribute(this.mfaTrustedAuthnAttributeName, (Object)Boolean.TRUE).build();
            LOGGER.debug("Updated authentication session to remember trusted MFA record via {}", (Object)this.mfaTrustedAuthnAttributeName);
            c.update(newAuthn);
        }
        return this.success();
    }

    public void setMfaTrustedAuthnAttributeName(String mfaTrustedAuthnAttributeName) {
        this.mfaTrustedAuthnAttributeName = mfaTrustedAuthnAttributeName;
    }

    public void setStorage(MultifactorAuthenticationTrustStorage storage) {
        this.storage = storage;
    }
}

