/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.web.flow;

import java.time.LocalDate;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProperties;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecord;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.trusted.util.MultifactorAuthenticationTrustUtils;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class MultifactorAuthenticationVerifyTrustAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthenticationVerifyTrustAction.class);
    private MultifactorAuthenticationTrustStorage storage;
    private MultifactorAuthenticationProperties.Trusted trustedProperties;

    protected Event doExecute(RequestContext requestContext) throws Exception {
        Authentication c = WebUtils.getAuthentication((RequestContext)requestContext);
        if (c == null) {
            LOGGER.warn("Could not determine authentication from the request context");
            return this.no();
        }
        String principal = c.getPrincipal().getId();
        LocalDate onOrAfter = LocalDate.now().minus(this.trustedProperties.getExpiration(), DateTimeUtils.toChronoUnit((TimeUnit)this.trustedProperties.getTimeUnit()));
        LOGGER.warn("Retrieving trusted authentication records for {} that are on/after {}", (Object)principal, (Object)onOrAfter);
        Set<MultifactorAuthenticationTrustRecord> results = this.storage.get(principal, onOrAfter);
        if (results.isEmpty()) {
            LOGGER.debug("No valid trusted authentication records could be found for {}", (Object)principal);
            return this.no();
        }
        String geography = MultifactorAuthenticationTrustUtils.generateGeography();
        LOGGER.debug("Retrieving authentication records for {} that match {}", (Object)principal, (Object)geography);
        if (!results.stream().filter(entry -> entry.getGeography().equals(geography)).findAny().isPresent()) {
            LOGGER.debug("No trusted authentication records could be found for {} to match the current geography", (Object)principal);
            return this.no();
        }
        LOGGER.debug("Trusted authentication records found for {} that matches the current geography", (Object)principal);
        requestContext.getFlashScope().put("mfaTrustedAuthentication", (Object)Boolean.TRUE);
        return this.yes();
    }

    public void setStorage(MultifactorAuthenticationTrustStorage storage) {
        this.storage = storage;
    }

    public void setTrustedProperties(MultifactorAuthenticationProperties.Trusted trustedProperties) {
        this.trustedProperties = trustedProperties;
    }
}

