/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.authentication.storage;

import java.time.LocalDate;
import java.util.concurrent.TimeUnit;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProperties;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.util.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

@EnableTransactionManagement(proxyTargetClass=true)
@Transactional(transactionManager="transactionManagerMfaAuthnTrust")
public class MultifactorAuthenticationTrustStorageCleaner {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthenticationTrustStorageCleaner.class);
    private final MultifactorAuthenticationProperties.Trusted trustedProperties;
    private final MultifactorAuthenticationTrustStorage storage;

    public MultifactorAuthenticationTrustStorageCleaner(MultifactorAuthenticationProperties.Trusted trustedProperties, MultifactorAuthenticationTrustStorage storage) {
        this.trustedProperties = trustedProperties;
        this.storage = storage;
    }

    @Scheduled(initialDelayString="${cas.authn.mfa.trusted.cleaner.startDelay:10000}", fixedDelayString="${cas.authn.mfa.trusted.cleaner.repeatInterval:60000}")
    public void clean() {
        if (!this.trustedProperties.getCleaner().isEnabled()) {
            LOGGER.debug("[{}] is disabled. Expired trusted authentication records will not automatically be cleaned up by CAS", (Object)this.getClass().getName());
            return;
        }
        try {
            LOGGER.debug("Proceeding to clean up expired trusted authentication records...");
            SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext((Object)this);
            LocalDate validDate = LocalDate.now().minus(this.trustedProperties.getExpiration(), DateTimeUtils.toChronoUnit((TimeUnit)this.trustedProperties.getTimeUnit()));
            LOGGER.info("Expiring records that are on/before [{}]", (Object)validDate);
            this.storage.expire(validDate);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

