/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.config;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.Serializable;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.trusted.authentication.MultifactorAuthenticationTrustCipherExecutor;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecord;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.trusted.authentication.storage.InMemoryMultifactorAuthenticationTrustStorage;
import org.apereo.cas.trusted.authentication.storage.MultifactorAuthenticationTrustStorageCleaner;
import org.apereo.cas.trusted.web.MultifactorAuthenticationTrustController;
import org.apereo.cas.trusted.web.flow.MultifactorAuthenticationSetTrustAction;
import org.apereo.cas.trusted.web.flow.MultifactorAuthenticationVerifyTrustAction;
import org.apereo.cas.util.cipher.NoOpCipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.integration.transaction.PseudoTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.webflow.execution.Action;

@Configuration(value="multifactorAuthnTrustConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@AutoConfigureAfter(value={CasCoreUtilConfiguration.class})
public class MultifactorAuthnTrustConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthnTrustConfiguration.class);
    private static final int INITIAL_CACHE_SIZE = 50;
    private static final long MAX_CACHE_SIZE = 1000L;
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    @RefreshScope
    public Action mfaSetTrustAction(@Qualifier(value="mfaTrustEngine") MultifactorAuthenticationTrustStorage storage) {
        return new MultifactorAuthenticationSetTrustAction(storage, this.casProperties.getAuthn().getMfa().getTrusted());
    }

    @Bean
    public MultifactorAuthenticationTrustController mfaTrustController(@Qualifier(value="mfaTrustEngine") MultifactorAuthenticationTrustStorage storage) {
        return new MultifactorAuthenticationTrustController(storage, this.casProperties.getAuthn().getMfa().getTrusted());
    }

    @Bean
    @RefreshScope
    public Action mfaVerifyTrustAction(@Qualifier(value="mfaTrustEngine") MultifactorAuthenticationTrustStorage storage) {
        return new MultifactorAuthenticationVerifyTrustAction(storage, this.casProperties.getAuthn().getMfa().getTrusted());
    }

    @ConditionalOnMissingBean(name={"mfaTrustEngine"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationTrustStorage mfaTrustEngine() {
        LoadingCache storage = CacheBuilder.newBuilder().initialCapacity(50).maximumSize(1000L).recordStats().expireAfterWrite(this.casProperties.getAuthn().getMfa().getTrusted().getExpiration(), this.casProperties.getAuthn().getMfa().getTrusted().getTimeUnit()).build((CacheLoader)new CacheLoader<String, MultifactorAuthenticationTrustRecord>(){

            public MultifactorAuthenticationTrustRecord load(String s) throws Exception {
                LOGGER.error("Load operation of the cache is not supported.");
                return null;
            }
        });
        InMemoryMultifactorAuthenticationTrustStorage m = new InMemoryMultifactorAuthenticationTrustStorage((LoadingCache<String, MultifactorAuthenticationTrustRecord>)storage);
        m.setCipherExecutor(this.mfaTrustCipherExecutor());
        return m;
    }

    @ConditionalOnMissingBean(name={"transactionManagerMfaAuthnTrust"})
    @Bean
    public PlatformTransactionManager transactionManagerMfaAuthnTrust() {
        return new PseudoTransactionManager();
    }

    @Bean
    @RefreshScope
    public CipherExecutor<Serializable, String> mfaTrustCipherExecutor() {
        if (this.casProperties.getAuthn().getMfa().getTrusted().isCipherEnabled()) {
            return new MultifactorAuthenticationTrustCipherExecutor(this.casProperties.getAuthn().getMfa().getTrusted().getEncryptionKey(), this.casProperties.getAuthn().getMfa().getTrusted().getSigningKey());
        }
        LOGGER.info("Multifactor trusted authentication record encryption/signing is turned off and MAY NOT be safe in a production environment. Consider using other choices to handle encryption, signing and verification of trusted authentication records for MFA");
        return NoOpCipherExecutor.getInstance();
    }

    @ConditionalOnMissingBean(name={"mfaTrustStorageCleaner"})
    @Bean
    @Lazy
    public MultifactorAuthenticationTrustStorageCleaner mfaTrustStorageCleaner(@Qualifier(value="mfaTrustEngine") MultifactorAuthenticationTrustStorage storage) {
        return new MultifactorAuthenticationTrustStorageCleaner(this.casProperties.getAuthn().getMfa().getTrusted(), storage);
    }
}

