/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.util;

import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecord;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.RequestContext;

public final class MultifactorAuthenticationTrustUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthenticationTrustUtils.class);

    private MultifactorAuthenticationTrustUtils() {
    }

    public static String generateKey(MultifactorAuthenticationTrustRecord r) {
        StringBuilder builder = new StringBuilder(r.getPrincipal());
        return builder.append('@').append(r.getGeography()).toString();
    }

    public static String generateGeography() {
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        String geography = clientInfo.getClientIpAddress().concat("@").concat(WebUtils.getHttpServletRequestUserAgent());
        return geography;
    }

    public static void trackTrustedMultifactorAuthenticationAttribute(Authentication authn, String attributeName) {
        Authentication newAuthn = DefaultAuthenticationBuilder.newInstance((Authentication)authn).addAttribute(attributeName, (Object)Boolean.TRUE).build();
        LOGGER.debug("Updated authentication session to remember trusted multifactor record via [{}]", (Object)attributeName);
        authn.update(newAuthn);
    }

    public static boolean isMultifactorAuthenticationTrustedInScope(RequestContext requestContext) {
        return requestContext.getFlashScope().contains("mfaTrustedAuthentication");
    }

    public static void setMultifactorAuthenticationTrustedInScope(RequestContext requestContext) {
        MutableAttributeMap flashScope = requestContext.getFlashScope();
        flashScope.put("mfaTrustedAuthentication", (Object)Boolean.TRUE);
    }
}

