/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.web;

import java.time.LocalDate;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProperties;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecord;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.util.DateTimeUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="mfaTrustController")
@RequestMapping(value={"/status/trustedDevices"})
public class MultifactorAuthenticationTrustController {
    private final MultifactorAuthenticationTrustStorage storage;
    private final MultifactorAuthenticationProperties.Trusted trustedProperties;

    public MultifactorAuthenticationTrustController(MultifactorAuthenticationTrustStorage storage, MultifactorAuthenticationProperties.Trusted trustedProperties) {
        this.storage = storage;
        this.trustedProperties = trustedProperties;
    }

    @GetMapping
    @ResponseBody
    public Set<MultifactorAuthenticationTrustRecord> getAllTrustedDevices(HttpServletResponse response, HttpServletRequest request) throws Exception {
        LocalDate onOrAfter = LocalDate.now().minus(this.trustedProperties.getExpiration(), DateTimeUtils.toChronoUnit((TimeUnit)this.trustedProperties.getTimeUnit()));
        return this.storage.get(onOrAfter);
    }
}

