/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.web.flow;

import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationCredentialsLocalBinder;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProperties;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecord;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.trusted.util.MultifactorAuthenticationTrustUtils;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class MultifactorAuthenticationSetTrustAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthenticationSetTrustAction.class);
    private static final String PARAM_NAME_DEVICE_NAME = "deviceName";
    private final MultifactorAuthenticationTrustStorage storage;
    private final MultifactorAuthenticationProperties.Trusted trustedProperties;

    public MultifactorAuthenticationSetTrustAction(MultifactorAuthenticationTrustStorage storage, MultifactorAuthenticationProperties.Trusted trustedProperties) {
        this.storage = storage;
        this.trustedProperties = trustedProperties;
    }

    public Event doExecute(RequestContext requestContext) throws Exception {
        Authentication c = WebUtils.getAuthentication((RequestContext)requestContext);
        if (c == null) {
            LOGGER.error("Could not determine authentication from the request context");
            return this.error();
        }
        AuthenticationCredentialsLocalBinder.bindCurrent((Authentication)c);
        String principal = c.getPrincipal().getId();
        if (!MultifactorAuthenticationTrustUtils.isMultifactorAuthenticationTrustedInScope(requestContext)) {
            String deviceName;
            LOGGER.debug("Attempt to store trusted authentication record for [{}]", (Object)principal);
            MultifactorAuthenticationTrustRecord record = MultifactorAuthenticationTrustRecord.newInstance(principal, MultifactorAuthenticationTrustUtils.generateGeography());
            if (requestContext.getRequestParameters().contains(PARAM_NAME_DEVICE_NAME) && StringUtils.isNotBlank((CharSequence)(deviceName = requestContext.getRequestParameters().get(PARAM_NAME_DEVICE_NAME)))) {
                record.setName(deviceName);
            }
            this.storage.set(record);
            LOGGER.debug("Saved trusted authentication record for [{}] under [{}]", (Object)principal, (Object)record.getName());
        }
        LOGGER.debug("Trusted authentication session exists for [{}]", (Object)principal);
        MultifactorAuthenticationTrustUtils.trackTrustedMultifactorAuthenticationAttribute(c, this.trustedProperties.getAuthenticationContextAttribute());
        return this.success();
    }
}

