/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.config;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
@Documented
@Conditional(value={MultifactorTrustedDevicesEnabledCondition.class})
public @interface ConditionalOnMultifactorTrustedDevicesEnabled {
    public String prefix();

    public static class MultifactorTrustedDevicesEnabledCondition
    extends SpringBootCondition {
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Map attributes = Objects.requireNonNull(metadata.getAnnotationAttributes(ConditionalOnMultifactorTrustedDevicesEnabled.class.getName()));
            String name = attributes.get("prefix").toString().concat(".trusted-device-enabled");
            String propertyValue = context.getEnvironment().getProperty(name);
            if (StringUtils.isBlank((CharSequence)propertyValue) || BooleanUtils.toBoolean((String)propertyValue)) {
                return ConditionOutcome.match((String)("Found matching property for " + name));
            }
            return ConditionOutcome.noMatch((String)("Could not find matching property for " + name));
        }
    }
}

