/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.config;

import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.trusted.authentication.DefaultMultifactorAuthenticationTrustedDeviceBypassEvaluator;
import org.apereo.cas.trusted.authentication.MultifactorAuthenticationTrustedDeviceBypassEvaluator;
import org.apereo.cas.trusted.authentication.MultifactorAuthenticationTrustedDeviceNamingStrategy;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.trusted.web.flow.MultifactorAuthenticationPrepareTrustDeviceViewAction;
import org.apereo.cas.trusted.web.flow.MultifactorAuthenticationSetTrustAction;
import org.apereo.cas.trusted.web.flow.MultifactorAuthenticationVerifyTrustAction;
import org.apereo.cas.trusted.web.flow.fingerprint.DeviceFingerprintStrategy;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Configuration(value="multifactorAuthnTrustWebflowConfiguration", proxyBeanMethods=false)
public class MultifactorAuthnTrustWebflowConfiguration {
    @ConditionalOnMissingBean(name={"mfaTrustedDeviceBypassEvaluator"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationTrustedDeviceBypassEvaluator mfaTrustedDeviceBypassEvaluator(@Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer) {
        return new DefaultMultifactorAuthenticationTrustedDeviceBypassEvaluator(registeredServiceAccessStrategyEnforcer);
    }

    @ConditionalOnMissingBean(name={"mfaSetTrustAction"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public Action mfaSetTrustAction(CasConfigurationProperties casProperties, @Qualifier(value="mfaTrustedDeviceBypassEvaluator") MultifactorAuthenticationTrustedDeviceBypassEvaluator mfaTrustedDeviceBypassEvaluator, @Qualifier(value="deviceFingerprintStrategy") DeviceFingerprintStrategy deviceFingerprintStrategy, @Qualifier(value="mfaTrustEngine") MultifactorAuthenticationTrustStorage mfaTrustEngine, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer) {
        return new MultifactorAuthenticationSetTrustAction(mfaTrustEngine, deviceFingerprintStrategy, casProperties.getAuthn().getMfa().getTrusted(), registeredServiceAccessStrategyEnforcer, mfaTrustedDeviceBypassEvaluator);
    }

    @ConditionalOnMissingBean(name={"mfaVerifyTrustAction"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public Action mfaVerifyTrustAction(CasConfigurationProperties casProperties, @Qualifier(value="mfaTrustedDeviceBypassEvaluator") MultifactorAuthenticationTrustedDeviceBypassEvaluator mfaTrustedDeviceBypassEvaluator, @Qualifier(value="deviceFingerprintStrategy") DeviceFingerprintStrategy deviceFingerprintStrategy, @Qualifier(value="mfaTrustEngine") MultifactorAuthenticationTrustStorage mfaTrustEngine, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer) {
        return new MultifactorAuthenticationVerifyTrustAction(mfaTrustEngine, deviceFingerprintStrategy, casProperties.getAuthn().getMfa().getTrusted(), registeredServiceAccessStrategyEnforcer, mfaTrustedDeviceBypassEvaluator);
    }

    @ConditionalOnMissingBean(name={"mfaPrepareTrustDeviceViewAction"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public Action mfaPrepareTrustDeviceViewAction(CasConfigurationProperties casProperties, @Qualifier(value="mfaTrustedDeviceBypassEvaluator") MultifactorAuthenticationTrustedDeviceBypassEvaluator mfaTrustedDeviceBypassEvaluator, @Qualifier(value="deviceFingerprintStrategy") DeviceFingerprintStrategy deviceFingerprintStrategy, @Qualifier(value="mfaTrustDeviceNamingStrategy") MultifactorAuthenticationTrustedDeviceNamingStrategy mfaTrustDeviceNamingStrategy, @Qualifier(value="mfaTrustEngine") MultifactorAuthenticationTrustStorage mfaTrustEngine, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
        return new MultifactorAuthenticationPrepareTrustDeviceViewAction(mfaTrustEngine, deviceFingerprintStrategy, casProperties.getAuthn().getMfa().getTrusted(), registeredServiceAccessStrategyEnforcer, servicesManager, mfaTrustedDeviceBypassEvaluator, mfaTrustDeviceNamingStrategy);
    }
}

