/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.trusted.config;

import java.util.Map;
import javax.annotation.PostConstruct;
import org.apereo.cas.adaptors.trusted.authentication.handler.support.PrincipalBearingCredentialsAuthenticationHandler;
import org.apereo.cas.adaptors.trusted.authentication.principal.PrincipalBearingPrincipalResolver;
import org.apereo.cas.adaptors.trusted.web.flow.PrincipalFromRequestRemoteUserNonInteractiveCredentialsAction;
import org.apereo.cas.adaptors.trusted.web.flow.PrincipalFromRequestUserPrincipalNonInteractiveCredentialsAction;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.webflow.execution.Action;

@Configuration(value="trustedAuthenticationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class TrustedAuthenticationConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="adaptiveAuthenticationPolicy")
    private AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy;
    @Autowired
    @Qualifier(value="serviceTicketRequestWebflowEventResolver")
    private CasWebflowEventResolver serviceTicketRequestWebflowEventResolver;
    @Autowired
    @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver")
    private CasWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="authenticationHandlersResolvers")
    private Map authenticationHandlersResolvers;
    @Autowired
    @Qualifier(value="attributeRepository")
    private IPersonAttributeDao attributeRepository;

    @Bean
    @RefreshScope
    public AuthenticationHandler principalBearingCredentialsAuthenticationHandler() {
        PrincipalBearingCredentialsAuthenticationHandler h = new PrincipalBearingCredentialsAuthenticationHandler();
        h.setPrincipalFactory(this.trustedPrincipalFactory());
        h.setServicesManager(this.servicesManager);
        return h;
    }

    @Bean
    @RefreshScope
    public PrincipalResolver trustedPrincipalResolver() {
        PrincipalBearingPrincipalResolver r = new PrincipalBearingPrincipalResolver();
        r.setAttributeRepository(this.attributeRepository);
        r.setPrincipalAttributeName(this.casProperties.getAuthn().getTrusted().getPrincipalAttribute());
        r.setReturnNullIfNoAttributes(this.casProperties.getAuthn().getTrusted().isReturnNull());
        r.setPrincipalFactory(this.trustedPrincipalFactory());
        return r;
    }

    @Bean
    public PrincipalFactory trustedPrincipalFactory() {
        return new DefaultPrincipalFactory();
    }

    @Bean
    @RefreshScope
    public Action principalFromRemoteUserAction() {
        PrincipalFromRequestRemoteUserNonInteractiveCredentialsAction a = new PrincipalFromRequestRemoteUserNonInteractiveCredentialsAction();
        a.setPrincipalFactory(this.trustedPrincipalFactory());
        a.setAdaptiveAuthenticationPolicy(this.adaptiveAuthenticationPolicy);
        a.setInitialAuthenticationAttemptWebflowEventResolver(this.initialAuthenticationAttemptWebflowEventResolver);
        a.setServiceTicketRequestWebflowEventResolver(this.serviceTicketRequestWebflowEventResolver);
        return a;
    }

    @Bean
    @RefreshScope
    public Action principalFromRemoteUserPrincipalAction() {
        PrincipalFromRequestUserPrincipalNonInteractiveCredentialsAction a = new PrincipalFromRequestUserPrincipalNonInteractiveCredentialsAction();
        a.setPrincipalFactory(this.trustedPrincipalFactory());
        a.setAdaptiveAuthenticationPolicy(this.adaptiveAuthenticationPolicy);
        a.setInitialAuthenticationAttemptWebflowEventResolver(this.initialAuthenticationAttemptWebflowEventResolver);
        a.setServiceTicketRequestWebflowEventResolver(this.serviceTicketRequestWebflowEventResolver);
        return a;
    }

    @PostConstruct
    public void initializeAuthenticationHandler() {
        this.authenticationHandlersResolvers.put(this.principalBearingCredentialsAuthenticationHandler(), this.trustedPrincipalResolver());
    }
}

