/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.trusted.web.flow;

import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.adaptors.trusted.authentication.principal.PrincipalBearingCredential;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.web.flow.AbstractNonInteractiveCredentialsAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.webflow.execution.RequestContext;

public class PrincipalFromRequestRemoteUserNonInteractiveCredentialsAction
extends AbstractNonInteractiveCredentialsAction {
    private transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private PrincipalFactory principalFactory;

    public void setPrincipalFactory(PrincipalFactory principalFactory) {
        this.principalFactory = principalFactory;
    }

    protected Credential constructCredentialsFromRequest(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        String remoteUser = request.getRemoteUser();
        if (StringUtils.hasText((String)remoteUser)) {
            this.logger.debug("Remote User [{}] found in HttpServletRequest", (Object)remoteUser);
            return new PrincipalBearingCredential(this.principalFactory.createPrincipal(remoteUser));
        }
        return null;
    }
}

