/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.trusted.config;

import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.trusted.authentication.handler.support.PrincipalBearingCredentialsAuthenticationHandler;
import org.apereo.cas.adaptors.trusted.authentication.principal.PrincipalBearingPrincipalResolver;
import org.apereo.cas.adaptors.trusted.authentication.principal.RemoteRequestPrincipalAttributesExtractor;
import org.apereo.cas.adaptors.trusted.authentication.principal.ShibbolethServiceProviderRequestPrincipalAttributesExtractor;
import org.apereo.cas.adaptors.trusted.web.flow.BasePrincipalFromNonInteractiveCredentialsAction;
import org.apereo.cas.adaptors.trusted.web.flow.ChainingPrincipalFromRequestNonInteractiveCredentialsAction;
import org.apereo.cas.adaptors.trusted.web.flow.PrincipalFromRequestHeaderNonInteractiveCredentialsAction;
import org.apereo.cas.adaptors.trusted.web.flow.PrincipalFromRequestRemoteUserNonInteractiveCredentialsAction;
import org.apereo.cas.adaptors.trusted.web.flow.PrincipalFromRequestUserPrincipalNonInteractiveCredentialsAction;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.resolvers.ChainingPrincipalResolver;
import org.apereo.cas.authentication.principal.resolvers.EchoingPrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PersonDirectoryPrincipalResolverProperties;
import org.apereo.cas.configuration.model.support.trusted.TrustedAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.webflow.execution.Action;

@Configuration(value="trustedAuthenticationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class TrustedAuthenticationConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="adaptiveAuthenticationPolicy")
    private ObjectProvider<AdaptiveAuthenticationPolicy> adaptiveAuthenticationPolicy;
    @Autowired
    @Qualifier(value="serviceTicketRequestWebflowEventResolver")
    private ObjectProvider<CasWebflowEventResolver> serviceTicketRequestWebflowEventResolver;
    @Autowired
    @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver")
    private ObjectProvider<CasDelegatingWebflowEventResolver> initialAuthenticationAttemptWebflowEventResolver;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="attributeRepository")
    private ObjectProvider<IPersonAttributeDao> attributeRepository;

    @Bean
    @RefreshScope
    public AuthenticationHandler principalBearingCredentialsAuthenticationHandler() {
        TrustedAuthenticationProperties trusted = this.casProperties.getAuthn().getTrusted();
        return new PrincipalBearingCredentialsAuthenticationHandler(trusted.getName(), (ServicesManager)this.servicesManager.getIfAvailable(), this.trustedPrincipalFactory(), trusted.getOrder());
    }

    @Bean
    @RefreshScope
    public PrincipalResolver trustedPrincipalResolver() {
        ChainingPrincipalResolver resolver = new ChainingPrincipalResolver();
        PersonDirectoryPrincipalResolverProperties personDirectory = this.casProperties.getPersonDirectory();
        TrustedAuthenticationProperties trusted = this.casProperties.getAuthn().getTrusted();
        String principalAttribute = (String)StringUtils.defaultIfBlank((CharSequence)trusted.getPrincipalAttribute(), (CharSequence)personDirectory.getPrincipalAttribute());
        PrincipalBearingPrincipalResolver bearingPrincipalResolver = new PrincipalBearingPrincipalResolver((IPersonAttributeDao)this.attributeRepository.getIfAvailable(), this.trustedPrincipalFactory(), trusted.isReturnNull() || personDirectory.isReturnNull(), principalAttribute, trusted.isUseExistingPrincipalId() || personDirectory.isUseExistingPrincipalId());
        resolver.setChain(CollectionUtils.wrapList((Object[])new PrincipalResolver[]{new EchoingPrincipalResolver(), bearingPrincipalResolver}));
        return resolver;
    }

    @ConditionalOnMissingBean(name={"trustedPrincipalFactory"})
    @Bean
    public PrincipalFactory trustedPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @ConditionalOnMissingBean(name={"remoteRequestPrincipalAttributesExtractor"})
    @Bean
    public RemoteRequestPrincipalAttributesExtractor remoteRequestPrincipalAttributesExtractor() {
        return new ShibbolethServiceProviderRequestPrincipalAttributesExtractor();
    }

    @Bean
    public BasePrincipalFromNonInteractiveCredentialsAction principalFromRemoteUserAction() {
        return new PrincipalFromRequestRemoteUserNonInteractiveCredentialsAction((CasDelegatingWebflowEventResolver)this.initialAuthenticationAttemptWebflowEventResolver.getIfAvailable(), (CasWebflowEventResolver)this.serviceTicketRequestWebflowEventResolver.getIfAvailable(), (AdaptiveAuthenticationPolicy)this.adaptiveAuthenticationPolicy.getIfAvailable(), this.trustedPrincipalFactory(), this.remoteRequestPrincipalAttributesExtractor());
    }

    @Bean
    public BasePrincipalFromNonInteractiveCredentialsAction principalFromRemoteUserPrincipalAction() {
        return new PrincipalFromRequestUserPrincipalNonInteractiveCredentialsAction((CasDelegatingWebflowEventResolver)this.initialAuthenticationAttemptWebflowEventResolver.getIfAvailable(), (CasWebflowEventResolver)this.serviceTicketRequestWebflowEventResolver.getIfAvailable(), (AdaptiveAuthenticationPolicy)this.adaptiveAuthenticationPolicy.getIfAvailable(), this.trustedPrincipalFactory(), this.remoteRequestPrincipalAttributesExtractor());
    }

    @Bean
    public BasePrincipalFromNonInteractiveCredentialsAction principalFromRemoteHeaderPrincipalAction() {
        TrustedAuthenticationProperties trusted = this.casProperties.getAuthn().getTrusted();
        return new PrincipalFromRequestHeaderNonInteractiveCredentialsAction((CasDelegatingWebflowEventResolver)this.initialAuthenticationAttemptWebflowEventResolver.getIfAvailable(), (CasWebflowEventResolver)this.serviceTicketRequestWebflowEventResolver.getIfAvailable(), (AdaptiveAuthenticationPolicy)this.adaptiveAuthenticationPolicy.getIfAvailable(), this.trustedPrincipalFactory(), this.remoteRequestPrincipalAttributesExtractor(), trusted.getRemotePrincipalHeader());
    }

    @ConditionalOnMissingBean(name={"remoteUserAuthenticationAction"})
    @Bean
    public Action remoteUserAuthenticationAction() {
        ChainingPrincipalFromRequestNonInteractiveCredentialsAction chain = new ChainingPrincipalFromRequestNonInteractiveCredentialsAction((CasDelegatingWebflowEventResolver)this.initialAuthenticationAttemptWebflowEventResolver.getIfAvailable(), (CasWebflowEventResolver)this.serviceTicketRequestWebflowEventResolver.getIfAvailable(), (AdaptiveAuthenticationPolicy)this.adaptiveAuthenticationPolicy.getIfAvailable(), this.trustedPrincipalFactory(), this.remoteRequestPrincipalAttributesExtractor());
        chain.addAction(this.principalFromRemoteUserAction());
        chain.addAction(this.principalFromRemoteUserPrincipalAction());
        chain.addAction(this.principalFromRemoteHeaderPrincipalAction());
        return chain;
    }

    @ConditionalOnMissingBean(name={"trustedAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer trustedAuthenticationEventExecutionPlanConfigurer() {
        return plan -> plan.registerAuthenticationHandlerWithPrincipalResolver(this.principalBearingCredentialsAuthenticationHandler(), this.trustedPrincipalResolver());
    }
}

