/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.trusted.web.flow;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.trusted.authentication.principal.PrincipalBearingCredential;
import org.apereo.cas.adaptors.trusted.authentication.principal.RemoteRequestPrincipalAttributesExtractor;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.web.flow.actions.AbstractNonInteractiveCredentialsAction;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.webflow.execution.RequestContext;

public abstract class BasePrincipalFromNonInteractiveCredentialsAction
extends AbstractNonInteractiveCredentialsAction
implements Ordered {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BasePrincipalFromNonInteractiveCredentialsAction.class);
    protected final PrincipalFactory principalFactory;
    private final RemoteRequestPrincipalAttributesExtractor principalAttributesExtractor;
    private int order = Integer.MAX_VALUE;

    public BasePrincipalFromNonInteractiveCredentialsAction(CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver, CasWebflowEventResolver serviceTicketRequestWebflowEventResolver, AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy, PrincipalFactory principalFactory, RemoteRequestPrincipalAttributesExtractor extractor) {
        super(initialAuthenticationAttemptWebflowEventResolver, serviceTicketRequestWebflowEventResolver, adaptiveAuthenticationPolicy);
        this.principalFactory = principalFactory;
        this.principalAttributesExtractor = extractor;
    }

    protected Credential constructCredentialsFromRequest(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        String remoteUser = this.getRemotePrincipalId(request);
        if (StringUtils.isNotBlank((CharSequence)remoteUser)) {
            LOGGER.debug("User [{}] found in HttpServletRequest", (Object)remoteUser);
            Map<String, Object> attributes = this.principalAttributesExtractor.getAttributes(request);
            LOGGER.debug("Attributes [{}] found in HttpServletRequest", attributes);
            return new PrincipalBearingCredential(this.principalFactory.createPrincipal(remoteUser, attributes));
        }
        LOGGER.debug("No user found in HttpServletRequest");
        return null;
    }

    protected abstract String getRemotePrincipalId(HttpServletRequest var1);

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public PrincipalFactory getPrincipalFactory() {
        return this.principalFactory;
    }

    @Generated
    public RemoteRequestPrincipalAttributesExtractor getPrincipalAttributesExtractor() {
        return this.principalAttributesExtractor;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }
}

