/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.trusted.web.flow;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.trusted.authentication.principal.RemoteRequestPrincipalAttributesExtractor;
import org.apereo.cas.adaptors.trusted.web.flow.BasePrincipalFromNonInteractiveCredentialsAction;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrincipalFromRequestHeaderNonInteractiveCredentialsAction
extends BasePrincipalFromNonInteractiveCredentialsAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PrincipalFromRequestHeaderNonInteractiveCredentialsAction.class);
    private static final int DEFAULT_SIZE = 20;
    private final String remotePrincipalHeader;

    public PrincipalFromRequestHeaderNonInteractiveCredentialsAction(CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver, CasWebflowEventResolver serviceTicketRequestWebflowEventResolver, AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy, PrincipalFactory principalFactory, RemoteRequestPrincipalAttributesExtractor extractor, String remotePrincipalHeader) {
        super(initialAuthenticationAttemptWebflowEventResolver, serviceTicketRequestWebflowEventResolver, adaptiveAuthenticationPolicy, principalFactory, extractor);
        this.remotePrincipalHeader = remotePrincipalHeader;
    }

    @Override
    protected String getRemotePrincipalId(HttpServletRequest request) {
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            LOGGER.debug("Principal [{}] found in request", (Object)principal.getName());
            return principal.getName();
        }
        String remoteUser = request.getRemoteUser();
        if (StringUtils.isNotBlank((CharSequence)remoteUser)) {
            LOGGER.debug("Remote user [{}] found in HttpServletRequest", (Object)remoteUser);
            return remoteUser;
        }
        if (StringUtils.isNotBlank((CharSequence)this.remotePrincipalHeader)) {
            Map<String, List<String>> headers = PrincipalFromRequestHeaderNonInteractiveCredentialsAction.getAllRequestHeaderValues(request);
            LOGGER.debug("Available request headers are [{}]. Locating first header value for [{}]", headers, (Object)this.remotePrincipalHeader);
            if (headers.containsKey(this.remotePrincipalHeader)) {
                String header = headers.get(this.remotePrincipalHeader).get(0);
                LOGGER.debug("Remote user [{}] found in [{}] header", (Object)header, (Object)this.remotePrincipalHeader);
                return header;
            }
        }
        LOGGER.debug("No remote user [{}] could be found", (Object)remoteUser);
        return null;
    }

    private static Map<String, List<String>> getAllRequestHeaderValues(HttpServletRequest request) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>(20);
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = request.getHeaders(name);
            if (values == null) continue;
            ArrayList<String> listValues = new ArrayList<String>(20);
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                listValues.add(value);
            }
            headers.put(name, listValues);
        }
        return headers;
    }
}

