/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.trusted.authentication.principal;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.adaptors.trusted.authentication.principal.PrincipalBearingCredential;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PrincipalBearingCredentialsTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "principalBearingCredential.json");
    private static final ObjectMapper MAPPER = new ObjectMapper().findAndRegisterModules();
    private PrincipalBearingCredential principalBearingCredentials;

    @BeforeEach
    public void initialize() {
        this.principalBearingCredentials = new PrincipalBearingCredential(new DefaultPrincipalFactory().createPrincipal("test"));
    }

    @Test
    public void verifyGetOfPrincipal() {
        Assertions.assertEquals((Object)"test", (Object)this.principalBearingCredentials.getPrincipal().getId());
    }

    @Test
    public void verifySerializeAPrincipalBearingCredentialToJson() throws IOException {
        MAPPER.writeValue(JSON_FILE, (Object)this.principalBearingCredentials);
        PrincipalBearingCredential credentialRead = (PrincipalBearingCredential)MAPPER.readValue(JSON_FILE, PrincipalBearingCredential.class);
        Assertions.assertEquals((Object)this.principalBearingCredentials, (Object)credentialRead);
    }
}

