/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.trusted.authentication.principal;

import java.util.Optional;
import org.apereo.cas.adaptors.trusted.authentication.principal.PrincipalBearingCredential;
import org.apereo.cas.adaptors.trusted.authentication.principal.PrincipalBearingPrincipalResolver;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.handler.support.SimpleTestUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.resolvers.PrincipalResolutionContext;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesCoreProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="Attributes")
public class PrincipalBearingCredentialsToPrincipalResolverTests {
    private PrincipalBearingPrincipalResolver resolver;

    @BeforeEach
    public void initialize() {
        PrincipalResolutionContext context = PrincipalResolutionContext.builder().attributeMerger(CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)PrincipalAttributesCoreProperties.MergingStrategyTypes.REPLACE)).attributeRepository((IPersonAttributeDao)CoreAuthenticationTestUtils.getAttributeRepository()).principalFactory(PrincipalFactoryUtils.newPrincipalFactory()).returnNullIfNoAttributes(false).principalNameTransformer(formUserId -> formUserId).useCurrentPrincipalId(false).resolveAttributes(true).activeAttributeRepositoryIdentifiers(CollectionUtils.wrapSet((Object)"*")).build();
        this.resolver = new PrincipalBearingPrincipalResolver(context);
    }

    @Test
    public void verifySupports() {
        PrincipalBearingCredential credential = new PrincipalBearingCredential(PrincipalFactoryUtils.newPrincipalFactory().createPrincipal("test"));
        Assertions.assertTrue((boolean)this.resolver.supports((Credential)credential));
        Assertions.assertFalse((boolean)this.resolver.supports((Credential)new UsernamePasswordCredential()));
        Assertions.assertFalse((boolean)this.resolver.supports(null));
    }

    @Test
    public void verifyReturnedPrincipal() {
        PrincipalBearingCredential credential = new PrincipalBearingCredential(PrincipalFactoryUtils.newPrincipalFactory().createPrincipal("test"));
        Principal p = this.resolver.resolve((Credential)credential, Optional.of(CoreAuthenticationTestUtils.getPrincipal()), Optional.of(new SimpleTestUsernamePasswordAuthenticationHandler()));
        Assertions.assertEquals((Object)"test", (Object)p.getId());
    }
}

