/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.trusted.web.flow;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.adaptors.trusted.web.flow.BaseNonInteractiveCredentialsActionTests;
import org.apereo.cas.adaptors.trusted.web.flow.PrincipalFromRequestExtractorAction;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.context.TestPropertySource;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;

@TestPropertySource(properties={"cas.authn.trusted.remote-principal-header=cas-header-name"})
@Tag(value="WebflowActions")
public class PrincipalFromRemoteRequestHeaderNonInteractiveCredentialsActionTests
extends BaseNonInteractiveCredentialsActionTests {
    @Autowired
    @Qualifier(value="principalFromRemoteHeaderPrincipalAction")
    private PrincipalFromRequestExtractorAction action;

    @Test
    public void verifyRemoteUserExists() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockRequestContext context = new MockRequestContext();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        request.addHeader("cas-header-name", (Object)"casuser");
        Assertions.assertEquals((Object)"success", (Object)this.action.execute((RequestContext)context).getId());
        Credential c = WebUtils.getCredential((RequestContext)context);
        Assertions.assertEquals((Object)"casuser", (Object)c.getId());
    }
}

